/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.batch.AbstractBatch;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbEntityType;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.DuplicateEngineException;
import com.feedzai.commons.sql.abstraction.engine.NameAlreadyExistsException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public interface DatabaseEngine {
    public void close();

    public void beginTransaction() throws DatabaseEngineRuntimeException;

    public void addEntity(DbEntity var1) throws DatabaseEngineException;

    public void updateEntity(DbEntity var1) throws DatabaseEngineException;

    public DbEntity removeEntity(String var1);

    public boolean containsEntity(String var1);

    public void dropEntity(String var1) throws DatabaseEngineException;

    public Long persist(String var1, EntityEntry var2) throws DatabaseEngineException;

    public Long persist(String var1, EntityEntry var2, boolean var3) throws DatabaseEngineException;

    public void flush() throws DatabaseEngineException;

    public void commit() throws DatabaseEngineRuntimeException;

    public void rollback() throws DatabaseEngineRuntimeException;

    public boolean isTransactionActive() throws DatabaseEngineRuntimeException;

    public int executeUpdate(String var1) throws DatabaseEngineException;

    public int executeUpdate(Expression var1) throws DatabaseEngineException;

    public String translate(Expression var1);

    public Dialect getDialect();

    public AbstractBatch createBatch(int var1, long var2);

    public boolean checkConnection(boolean var1);

    public boolean checkConnection();

    public void addBatch(String var1, EntityEntry var2) throws DatabaseEngineException;

    public List<Map<String, ResultColumn>> query(Expression var1) throws DatabaseEngineException;

    public List<Map<String, ResultColumn>> query(String var1) throws DatabaseEngineException;

    public Map<String, DbEntityType> getEntities() throws DatabaseEngineException;

    public Map<String, DbColumnType> getMetadata(String var1) throws DatabaseEngineException;

    public Map<String, DbColumnType> getQueryMetadata(Expression var1) throws DatabaseEngineException;

    public Map<String, DbColumnType> getQueryMetadata(String var1) throws DatabaseEngineException;

    public DatabaseEngine duplicate(Properties var1, boolean var2) throws DuplicateEngineException;

    public PdbProperties getProperties();

    public void createPreparedStatement(String var1, Expression var2) throws NameAlreadyExistsException, DatabaseEngineException;

    public void createPreparedStatement(String var1, String var2) throws NameAlreadyExistsException, DatabaseEngineException;

    public void createPreparedStatement(String var1, Expression var2, int var3) throws NameAlreadyExistsException, DatabaseEngineException;

    public void createPreparedStatement(String var1, String var2, int var3) throws NameAlreadyExistsException, DatabaseEngineException;

    public void removePreparedStatement(String var1);

    public List<Map<String, ResultColumn>> getPSResultSet(String var1) throws DatabaseEngineException;

    public void setParameters(String var1, Object ... var2) throws DatabaseEngineException, ConnectionResetException;

    public void setParameter(String var1, int var2, Object var3) throws DatabaseEngineException, ConnectionResetException;

    public void executePS(String var1) throws DatabaseEngineException, ConnectionResetException;

    public void clearParameters(String var1) throws DatabaseEngineException, ConnectionResetException;

    public boolean preparedStatementExists(String var1);

    public void executePSUpdate(String var1) throws DatabaseEngineException, ConnectionResetException;

    public String commentCharacter();

    public String escapeCharacter();
}

