/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.ArrayList;

public class View
extends Expression {
    private final String name;
    private boolean replace = false;
    private Expression as;

    public View(String name) {
        this.name = StringUtil.escapeSql(name);
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (this.replace) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtil.quotize(this.name));
        res.add("AS " + this.as.translateDB2(properties));
        return StringUtil.join(res, " ");
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (this.replace) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtil.quotize(this.name));
        res.add("AS " + this.as.translateOracle(properties));
        return StringUtil.join(res, " ");
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (this.replace) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtil.quotize(this.name, "`"));
        res.add("AS " + this.as.translateMySQL(properties));
        return StringUtil.join(res, " ");
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE VIEW");
        res.add(StringUtil.quotize(this.name));
        res.add("AS " + this.as.translateSQLServer(properties));
        return StringUtil.join(res, " ");
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (this.replace) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtil.quotize(this.name));
        res.add("AS " + this.as.translatePostgreSQL(properties));
        return StringUtil.join(res, " ");
    }

    @Override
    public String translateH2(PdbProperties properties) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (this.replace) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtil.quotize(this.name));
        res.add("AS " + this.as.translateH2(properties));
        return StringUtil.join(res, " ");
    }

    public View replace() {
        this.replace = true;
        return this;
    }

    public View as(Expression as) {
        this.as = as;
        return this;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public String getName() {
        return this.name;
    }
}

