/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Update
extends Expression {
    private final Expression table;
    private final List<Expression> columns = new ArrayList<Expression>();
    private Expression where = null;

    public Update(Expression table) {
        this.table = table;
    }

    public Update set(Expression ... exps) {
        this.columns.addAll(Arrays.asList(exps));
        return this;
    }

    public Update set(Collection<? extends Expression> exps) {
        this.columns.addAll(exps);
        return this;
    }

    public Update where(Expression where) {
        this.where = where;
        return this;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(this.table.translateDB2(properties));
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : this.columns) {
            setTranslations.add(e.translateDB2(properties));
        }
        temp.add(StringUtil.join(setTranslations, ", "));
        if (this.where != null) {
            temp.add("WHERE");
            temp.add(this.where.translateDB2(properties));
        }
        return StringUtil.join(temp, " ");
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(this.table.translateOracle(properties));
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : this.columns) {
            setTranslations.add(e.translateOracle(properties));
        }
        temp.add(StringUtil.join(setTranslations, ", "));
        if (this.where != null) {
            temp.add("WHERE");
            temp.add(this.where.translateOracle(properties));
        }
        return StringUtil.join(temp, " ");
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(this.table.translateMySQL(properties));
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias, "`"));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : this.columns) {
            setTranslations.add(e.translateMySQL(properties));
        }
        temp.add(StringUtil.join(setTranslations, ", "));
        if (this.where != null) {
            temp.add("WHERE");
            temp.add(this.where.translateMySQL(properties));
        }
        return StringUtil.join(temp, " ");
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias));
        } else {
            temp.add(this.table.translateSQLServer(properties));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : this.columns) {
            setTranslations.add(e.translateSQLServer(properties));
        }
        temp.add(StringUtil.join(setTranslations, ", "));
        temp.add("FROM");
        temp.add(this.table.translateSQLServer(properties));
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias));
        }
        if (this.where != null) {
            temp.add("WHERE");
            temp.add(this.where.translateSQLServer(properties));
        }
        return StringUtil.join(temp, " ");
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(this.table.translatePostgreSQL(properties));
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : this.columns) {
            setTranslations.add(e.translatePostgreSQL(properties));
        }
        temp.add(StringUtil.join(setTranslations, ", "));
        if (this.where != null) {
            temp.add("WHERE");
            temp.add(this.where.translatePostgreSQL(properties));
        }
        return StringUtil.join(temp, " ");
    }

    @Override
    public String translateH2(PdbProperties properties) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(this.table.translateH2(properties));
        if (this.table.isAliased()) {
            temp.add(StringUtil.quotize(this.table.alias));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : this.columns) {
            setTranslations.add(e.translateH2(properties));
        }
        temp.add(StringUtil.join(setTranslations, ", "));
        if (this.where != null) {
            temp.add("WHERE");
            temp.add(this.where.translateH2(properties));
        }
        return StringUtil.join(temp, " ");
    }
}

