/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RepeatDelimiter
extends Expression {
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String PLUS = " + ";
    public static final String MINUS = " - ";
    public static final String MULT = " * ";
    public static final String DIV = " / ";
    public static final String GT = " > ";
    public static final String LT = " < ";
    public static final String GTEQ = " >= ";
    public static final String LTEQ = " <= ";
    public static final String LIKE = " LIKE ";
    public static final String EQ = " = ";
    public static final String NEQ = " <> ";
    public static final String SEMICOLON = ", ";
    public static final String IN = " IN ";
    public static final String NOTIN = " NOT IN ";
    private String delimiter;
    private final List<Expression> exps = new ArrayList<Expression>();

    public RepeatDelimiter(String delimiter, Expression ... dbe) {
        this.delimiter = delimiter;
        this.exps.addAll(Arrays.asList(dbe));
    }

    public RepeatDelimiter(String delimiter, Collection<? extends Expression> dbe) {
        this.delimiter = delimiter;
        this.exps.addAll(dbe);
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        ArrayList<String> all = new ArrayList<String>();
        for (Expression dbe : this.exps) {
            all.add(dbe.translateDB2(properties));
        }
        if (DIV.equals(this.delimiter)) {
            if (this.isEnclosed()) {
                return "(1.0*" + StringUtil.join(all, this.delimiter) + ")";
            }
            return "1.0*" + StringUtil.join(all, this.delimiter);
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(all, this.delimiter) + ")";
        }
        return StringUtil.join(all, this.delimiter);
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        ArrayList<String> all = new ArrayList<String>();
        for (Expression dbe : this.exps) {
            all.add(dbe.translateOracle(properties));
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(all, this.delimiter) + ")";
        }
        return StringUtil.join(all, this.delimiter);
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        ArrayList<String> all = new ArrayList<String>();
        for (Expression dbe : this.exps) {
            all.add(dbe.translateMySQL(properties));
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(all, this.delimiter) + ")";
        }
        return StringUtil.join(all, this.delimiter);
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        ArrayList<String> all = new ArrayList<String>();
        if (this.delimiter.equals(DIV)) {
            all.add(String.format("CONVERT(DOUBLE PRECISION, %s)", this.exps.get(0).translateSQLServer(properties)));
        } else {
            all.add(this.exps.get(0).translateSQLServer(properties));
        }
        for (int i = 1; i < this.exps.size(); ++i) {
            all.add(this.exps.get(i).translateSQLServer(properties));
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(all, this.delimiter) + ")";
        }
        return StringUtil.join(all, this.delimiter);
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        ArrayList<String> all = new ArrayList<String>();
        if (this.delimiter.equals(DIV)) {
            all.add(String.format("CAST(%s AS DOUBLE PRECISION)", this.exps.get(0).translatePostgreSQL(properties)));
        } else {
            all.add(this.exps.get(0).translatePostgreSQL(properties));
        }
        for (int i = 1; i < this.exps.size(); ++i) {
            all.add(this.exps.get(i).translatePostgreSQL(properties));
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(all, this.delimiter) + ")";
        }
        return StringUtil.join(all, this.delimiter);
    }

    @Override
    public String translateH2(PdbProperties properties) {
        ArrayList<String> all = new ArrayList<String>();
        if (this.delimiter.equals(DIV)) {
            all.add(String.format("CAST(%s AS DOUBLE PRECISION)", this.exps.get(0).translateH2(properties)));
        } else {
            all.add(this.exps.get(0).translateH2(properties));
        }
        for (int i = 1; i < this.exps.size(); ++i) {
            all.add(this.exps.get(i).translateH2(properties));
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(all, this.delimiter) + ")";
        }
        return StringUtil.join(all, this.delimiter);
    }
}

