/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;

public class Rename
extends Expression {
    private final Expression oldName;
    private final Expression newName;

    public Rename(Expression oldName, Expression newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        return String.format("RENAME TABLE %s TO %s", this.oldName.translateDB2(properties), this.newName.translateDB2(properties));
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        return String.format("ALTER TABLE %s RENAME TO %s", this.oldName.translateOracle(properties), this.newName.translateOracle(properties));
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        return String.format("RENAME TABLE %s TO %s", this.oldName.translateMySQL(properties), this.newName.translateMySQL(properties));
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        return String.format("sp_rename %s, %s", this.oldName.translateSQLServer(properties), this.newName.translateSQLServer(properties));
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        return String.format("ALTER TABLE %s RENAME TO %s", this.oldName.translatePostgreSQL(properties), this.newName.translatePostgreSQL(properties));
    }

    @Override
    public String translateH2(PdbProperties properties) {
        return String.format("ALTER TABLE %s RENAME TO %s", this.oldName.translateH2(properties), this.newName.translateH2(properties));
    }
}

