/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.dialect.SqlBuilder;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Query
extends Expression {
    private final List<Expression> selectColumns = new ArrayList<Expression>();
    private final List<Expression> fromColumns = new ArrayList<Expression>();
    private Expression where = null;
    private final List<Expression> groupbyColumns = new ArrayList<Expression>();
    private Expression having = null;
    private final List<Expression> orderbyColumns = new ArrayList<Expression>();
    private Integer limit = 0;
    private Integer offset = 0;
    private boolean distinct = false;

    public Query distinct() {
        this.distinct = true;
        return this;
    }

    public Query select(Expression ... selectColumns) {
        if (selectColumns == null) {
            return this;
        }
        this.selectColumns.addAll(Arrays.asList(selectColumns));
        return this;
    }

    public Query select(Collection<? extends Expression> selectColumns) {
        this.selectColumns.addAll(selectColumns);
        return this;
    }

    public Query from(Expression ... fromColumns) {
        if (fromColumns == null) {
            return this;
        }
        this.fromColumns.addAll(Arrays.asList(fromColumns));
        return this;
    }

    public Query from(Collection<? extends Expression> fromColumns) {
        if (fromColumns == null) {
            return this;
        }
        this.fromColumns.addAll(fromColumns);
        return this;
    }

    public Query andWhere(Expression where) {
        this.where = this.where == null ? where : SqlBuilder.and(this.where.enclose(), where.enclose());
        return this;
    }

    public Query where(Expression where) {
        this.where = where;
        return this;
    }

    public Query groupby(Expression ... groupbyColumns) {
        if (groupbyColumns == null) {
            return this;
        }
        this.groupbyColumns.addAll(Arrays.asList(groupbyColumns));
        return this;
    }

    public Query groupby(Collection<? extends Expression> groupbyColumns) {
        if (groupbyColumns == null) {
            return this;
        }
        this.groupbyColumns.addAll(groupbyColumns);
        return this;
    }

    public Query having(Expression having) {
        this.having = having;
        return this;
    }

    public Query orderby(Expression ... orderbyColumns) {
        if (orderbyColumns == null) {
            return this;
        }
        this.orderbyColumns.addAll(Arrays.asList(orderbyColumns));
        return this;
    }

    public Query orderby(Collection<? extends Expression> orderbyColumns) {
        if (orderbyColumns == null) {
            return this;
        }
        this.orderbyColumns.addAll(orderbyColumns);
        return this;
    }

    public Query limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query offset(Integer offset) {
        this.offset = offset;
        if (this.limit <= 0) {
            this.limit = Integer.MAX_VALUE - offset;
        }
        return this;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (this.distinct ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : this.selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translateDB2(properties) + (dbe.alias == null ? ")" : ") AS " + StringUtil.quotize(dbe.alias)));
                continue;
            }
            querySelectColumns.add(dbe.translateDB2(properties) + (dbe.alias == null ? "" : " AS " + StringUtil.quotize(dbe.alias)));
        }
        query.add(StringUtil.join(querySelectColumns, ", "));
        query.add("FROM");
        if (!this.fromColumns.isEmpty()) {
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : this.fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translateDB2(properties) + (dbe.alias == null ? ")" : ") " + StringUtil.quotize(dbe.alias)));
                } else {
                    insideFrom.add(dbe.translateDB2(properties) + (dbe.alias == null ? "" : " " + StringUtil.quotize(dbe.alias)));
                }
                if (!dbe.joins.isEmpty()) {
                    for (Join j : dbe.joins) {
                        insideFrom.add(j.translateDB2(properties));
                    }
                }
                queryFromColumns.add(StringUtil.join(insideFrom, " "));
            }
            query.add(StringUtil.join(queryFromColumns, ", "));
        } else {
            query.add("sysibm.sysdummy1");
        }
        if (this.where != null) {
            query.add("WHERE");
            query.add(this.where.translateDB2(properties));
        }
        if (!this.groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : this.groupbyColumns) {
                queryGroupByColumns.add(column.translateDB2(properties));
            }
            query.add(StringUtil.join(queryGroupByColumns, ", "));
        }
        if (this.having != null) {
            query.add("HAVING");
            query.add(this.having.translateDB2(properties));
        }
        if (!this.orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : this.orderbyColumns) {
                queryOrderByColumns.add(column.translateDB2(properties));
            }
            query.add(StringUtil.join(queryOrderByColumns, ", "));
        }
        String finalQuery = StringUtil.join(query, " ");
        if (this.limit > 0) {
            finalQuery = this.offset > 0 ? String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER() rnum ,offlim.* FROM (%s) offlim) WHERE rnum <= %d AND rnum > %d", finalQuery, this.limit + this.offset, this.offset) : String.format("SELECT * FROM (%s) FETCH FIRST %d ROWS ONLY", finalQuery, this.limit);
        }
        return this.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (this.distinct ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : this.selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translateOracle(properties) + (dbe.alias == null ? ")" : ") AS " + StringUtil.quotize(dbe.alias)));
                continue;
            }
            querySelectColumns.add(dbe.translateOracle(properties) + (dbe.alias == null ? "" : " AS " + StringUtil.quotize(dbe.alias)));
        }
        query.add(StringUtil.join(querySelectColumns, ", "));
        query.add("FROM");
        if (!this.fromColumns.isEmpty()) {
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : this.fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translateOracle(properties) + (dbe.alias == null ? ")" : ") " + StringUtil.quotize(dbe.alias)));
                } else {
                    insideFrom.add(dbe.translateOracle(properties) + (dbe.alias == null ? "" : " " + StringUtil.quotize(dbe.alias)));
                }
                if (!dbe.joins.isEmpty()) {
                    for (Join j : dbe.joins) {
                        insideFrom.add(j.translateOracle(properties));
                    }
                }
                queryFromColumns.add(StringUtil.join(insideFrom, " "));
            }
            query.add(StringUtil.join(queryFromColumns, ", "));
        } else {
            query.add(StringUtil.quotize("DUAL"));
        }
        if (this.where != null) {
            query.add("WHERE");
            query.add(this.where.translateOracle(properties));
        }
        if (!this.groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : this.groupbyColumns) {
                queryGroupByColumns.add(column.translateOracle(properties));
            }
            query.add(StringUtil.join(queryGroupByColumns, ", "));
        }
        if (this.having != null) {
            query.add("HAVING");
            query.add(this.having.translateOracle(properties));
        }
        if (!this.orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : this.orderbyColumns) {
                queryOrderByColumns.add(column.translateOracle(properties));
            }
            query.add(StringUtil.join(queryOrderByColumns, ", "));
        }
        String finalQuery = StringUtil.join(query, " ");
        if (this.limit > 0) {
            finalQuery = this.offset > 0 ? String.format("SELECT * FROM (SELECT rownum rnum ,offlim.* FROM (%s) offlim WHERE rownum <= %d) WHERE rnum > %d", finalQuery, this.limit + this.offset, this.offset) : String.format("SELECT * FROM (%s) a WHERE rownum <= %d", finalQuery, this.limit);
        }
        return this.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (this.distinct ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : this.selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translateMySQL(properties) + (dbe.alias == null ? ")" : ") AS " + StringUtil.quotize(dbe.alias, "`")));
                continue;
            }
            querySelectColumns.add(dbe.translateMySQL(properties) + (dbe.alias == null ? "" : " AS " + StringUtil.quotize(dbe.alias, "`")));
        }
        query.add(StringUtil.join(querySelectColumns, ", "));
        if (!this.fromColumns.isEmpty()) {
            query.add("FROM");
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : this.fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translateMySQL(properties) + (dbe.alias == null ? ")" : ") " + StringUtil.quotize(dbe.alias, "`")));
                } else {
                    insideFrom.add(dbe.translateMySQL(properties) + (dbe.alias == null ? "" : " " + StringUtil.quotize(dbe.alias, "`")));
                }
                if (!dbe.joins.isEmpty()) {
                    for (Join j : dbe.joins) {
                        insideFrom.add(j.translateMySQL(properties));
                    }
                }
                queryFromColumns.add(StringUtil.join(insideFrom, " "));
            }
            query.add(StringUtil.join(queryFromColumns, ", "));
        }
        if (this.where != null) {
            query.add("WHERE");
            query.add(this.where.translateMySQL(properties));
        }
        if (!this.groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : this.groupbyColumns) {
                queryGroupByColumns.add(column.translateMySQL(properties));
            }
            query.add(StringUtil.join(queryGroupByColumns, ", "));
        }
        if (this.having != null) {
            query.add("HAVING");
            query.add(this.having.translateMySQL(properties));
        }
        if (!this.orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : this.orderbyColumns) {
                queryOrderByColumns.add(column.translateMySQL(properties));
            }
            query.add(StringUtil.join(queryOrderByColumns, ", "));
        }
        if (this.limit > 0) {
            if (this.offset > 0) {
                query.add(String.format("LIMIT %d,%d", this.offset, this.limit));
            } else {
                query.add(String.format("LIMIT %d", this.limit));
            }
        }
        String finalQuery = StringUtil.join(query, " ");
        return this.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (this.distinct ? " DISTINCT" : "") + (this.limit <= 0 || this.offset > 0 ? "" : " TOP " + this.limit));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : this.selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translateSQLServer(properties) + (dbe.alias == null ? ")" : ") AS " + StringUtil.quotize(dbe.alias)));
                continue;
            }
            querySelectColumns.add(dbe.translateSQLServer(properties) + (dbe.alias == null ? "" : " AS " + StringUtil.quotize(dbe.alias)));
        }
        query.add(StringUtil.join(querySelectColumns, ", "));
        if (!this.fromColumns.isEmpty()) {
            query.add("FROM");
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : this.fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translateSQLServer(properties) + (dbe.alias == null ? ")" : ") " + StringUtil.quotize(dbe.alias)));
                } else {
                    insideFrom.add(dbe.translateSQLServer(properties) + (dbe.alias == null ? "" : " " + StringUtil.quotize(dbe.alias)) + (dbe.isWithNoLock() ? " WITH(NOLOCK)" : ""));
                }
                if (!dbe.joins.isEmpty()) {
                    for (Join j : dbe.joins) {
                        insideFrom.add(j.translateSQLServer(properties));
                    }
                }
                queryFromColumns.add(StringUtil.join(insideFrom, " "));
            }
            query.add(StringUtil.join(queryFromColumns, ", "));
        }
        if (this.where != null) {
            query.add("WHERE");
            query.add(this.where.translateSQLServer(properties));
        }
        if (!this.groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : this.groupbyColumns) {
                queryGroupByColumns.add(column.translateSQLServer(properties));
            }
            query.add(StringUtil.join(queryGroupByColumns, ", "));
        }
        if (this.having != null) {
            query.add("HAVING");
            query.add(this.having.translateSQLServer(properties));
        }
        if (this.offset <= 0 && !this.orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : this.orderbyColumns) {
                queryOrderByColumns.add(column.translateSQLServer(properties));
            }
            query.add(StringUtil.join(queryOrderByColumns, ", "));
        }
        String finalQuery = StringUtil.join(query, " ");
        if (this.limit > 0 && this.offset > 0) {
            if (!this.orderbyColumns.isEmpty()) {
                ArrayList<String> queryOrderByColumns = new ArrayList<String>();
                for (Expression column : this.orderbyColumns) {
                    queryOrderByColumns.add(column.translateSQLServer(properties));
                }
                String orderByClause = StringUtil.join(queryOrderByColumns, ", ");
                finalQuery = String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY %s) rnum ,offlim.* FROM (%s) offlim) offlim WHERE rnum <= %d and rnum > %d ORDER BY %s", orderByClause, finalQuery, this.limit + this.offset, this.offset, orderByClause);
            } else {
                finalQuery = String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY (SELECT 1)) rnum ,offlim.* FROM (%s) offlim) offlim WHERE rnum <= %d and rnum > %d", finalQuery, this.limit + this.offset, this.offset);
            }
        }
        return this.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (this.distinct ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : this.selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translatePostgreSQL(properties) + (dbe.alias == null ? ")" : ") AS " + StringUtil.quotize(dbe.alias)));
                continue;
            }
            querySelectColumns.add(dbe.translatePostgreSQL(properties) + (dbe.alias == null ? "" : " AS " + StringUtil.quotize(dbe.alias)));
        }
        query.add(StringUtil.join(querySelectColumns, ", "));
        if (!this.fromColumns.isEmpty()) {
            query.add("FROM");
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : this.fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translatePostgreSQL(properties) + (dbe.alias == null ? ")" : ") " + StringUtil.quotize(dbe.alias)));
                } else {
                    insideFrom.add(dbe.translatePostgreSQL(properties) + (dbe.alias == null ? "" : " " + StringUtil.quotize(dbe.alias)));
                }
                if (!dbe.joins.isEmpty()) {
                    for (Join j : dbe.joins) {
                        insideFrom.add(j.translatePostgreSQL(properties));
                    }
                }
                queryFromColumns.add(StringUtil.join(insideFrom, " "));
            }
            query.add(StringUtil.join(queryFromColumns, ", "));
        }
        if (this.where != null) {
            query.add("WHERE");
            query.add(this.where.translatePostgreSQL(properties));
        }
        if (!this.groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : this.groupbyColumns) {
                queryGroupByColumns.add(column.translatePostgreSQL(properties));
            }
            query.add(StringUtil.join(queryGroupByColumns, ", "));
        }
        if (this.having != null) {
            query.add("HAVING");
            query.add(this.having.translatePostgreSQL(properties));
        }
        if (!this.orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : this.orderbyColumns) {
                queryOrderByColumns.add(column.translatePostgreSQL(properties));
            }
            query.add(StringUtil.join(queryOrderByColumns, ", "));
        }
        if (this.limit > 0) {
            if (this.offset > 0) {
                query.add(String.format("LIMIT %d OFFSET %d", this.limit, this.offset));
            } else {
                query.add(String.format("LIMIT %d", this.limit));
            }
        }
        String finalQuery = StringUtil.join(query, " ");
        return this.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translateH2(PdbProperties properties) {
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (this.distinct ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : this.selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translateH2(properties) + (dbe.alias == null ? ")" : ") AS " + StringUtil.quotize(dbe.alias)));
                continue;
            }
            querySelectColumns.add(dbe.translateH2(properties) + (dbe.alias == null ? "" : " AS " + StringUtil.quotize(dbe.alias)));
        }
        query.add(StringUtil.join(querySelectColumns, ", "));
        if (!this.fromColumns.isEmpty()) {
            query.add("FROM");
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : this.fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translateH2(properties) + (dbe.alias == null ? ")" : ") " + StringUtil.quotize(dbe.alias)));
                } else {
                    insideFrom.add(dbe.translateH2(properties) + (dbe.alias == null ? "" : " " + StringUtil.quotize(dbe.alias)));
                }
                if (!dbe.joins.isEmpty()) {
                    for (Join j : dbe.joins) {
                        insideFrom.add(j.translatePostgreSQL(properties));
                    }
                }
                queryFromColumns.add(StringUtil.join(insideFrom, " "));
            }
            query.add(StringUtil.join(queryFromColumns, ", "));
        }
        if (this.where != null) {
            query.add("WHERE");
            query.add(this.where.translateH2(properties));
        }
        if (!this.groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : this.groupbyColumns) {
                queryGroupByColumns.add(column.translateH2(properties));
            }
            query.add(StringUtil.join(queryGroupByColumns, ", "));
        }
        if (this.having != null) {
            query.add("HAVING");
            query.add(this.having.translateH2(properties));
        }
        if (!this.orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : this.orderbyColumns) {
                queryOrderByColumns.add(column.translateH2(properties));
            }
            query.add(StringUtil.join(queryOrderByColumns, ", "));
        }
        if (this.limit > 0) {
            if (this.offset > 0) {
                query.add(String.format("LIMIT %d OFFSET %d", this.limit, this.offset));
            } else {
                query.add(String.format("LIMIT %d", this.limit));
            }
        }
        String finalQuery = StringUtil.join(query, " ");
        return this.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }
}

