/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.ArrayList;

public class Name
extends Expression {
    private String environment = null;
    private final String name;
    private boolean isNull = false;
    private boolean isNotNull = false;

    public Name(String name) {
        this.name = name;
    }

    public Name(String tableName, String name) {
        this.environment = StringUtil.escapeSql(tableName);
        this.name = StringUtil.escapeSql(name);
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        return this.getName("\"");
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        return this.getName("\"");
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        return this.getName("`");
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        return this.getName("\"");
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        return this.getName("\"");
    }

    @Override
    public String translateH2(PdbProperties properties) {
        return this.getName("\"");
    }

    public Name isNull() {
        this.isNull = true;
        return this;
    }

    public Name isNotNull() {
        this.isNotNull = true;
        return this;
    }

    private String getName(String quoteCharacter) {
        ArrayList<String> res = new ArrayList<String>();
        if (this.environment != null) {
            res.add(StringUtil.quotize(this.environment, quoteCharacter) + "." + (this.isQuote() ? StringUtil.quotize(this.name, quoteCharacter) : this.name));
        } else {
            res.add(this.isQuote() ? StringUtil.quotize(this.name, quoteCharacter) : this.name);
        }
        if (this.ordering != null) {
            res.add(this.ordering);
        }
        if (this.isNull) {
            res.add("IS NULL");
        }
        if (this.isNotNull) {
            res.add("IS NOT NULL");
        }
        if (this.isEnclosed()) {
            return "(" + StringUtil.join(res, " ") + ")";
        }
        return StringUtil.join(res, " ");
    }

    public String getName() {
        return this.name;
    }
}

