/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;

public class Modulo
extends Expression {
    private final Expression dividend;
    private final Expression divisor;

    public Modulo(Expression dividend, Expression divisor) {
        this.dividend = dividend;
        this.divisor = divisor;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        String result = String.format("MOD(%s, %s)", this.dividend.translateDB2(properties), this.divisor.translateDB2(properties));
        return result;
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        String result = String.format("MOD(%s, %s)", this.dividend.translateOracle(properties), this.divisor.translateOracle(properties));
        return result;
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        String result = String.format("MOD(%s, %s)", this.dividend.translateMySQL(properties), this.divisor.translateMySQL(properties));
        return result;
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        String result = String.format("%s %% %s", this.dividend.translateSQLServer(properties), this.divisor.translateSQLServer(properties));
        return this.isEnclosed() ? "(" + result + ")" : result;
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        String result = String.format("MOD(%s, %s)", this.dividend.translatePostgreSQL(properties), this.divisor.translatePostgreSQL(properties));
        return result;
    }

    @Override
    public String translateH2(PdbProperties properties) {
        String result = String.format("MOD(%s, %s)", this.dividend.translateH2(properties), this.divisor.translateH2(properties));
        return result;
    }
}

