/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;

public class Join
extends Expression {
    private String join = null;
    private Expression joinTable = null;
    private Expression joinExpr = null;

    public Join(String join, Expression joinTable, Expression joinExpr) {
        this.join = StringUtil.escapeSql(join);
        this.joinTable = joinTable;
        this.joinExpr = joinExpr;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        if (this.joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", this.join, this.joinTable.translateDB2(properties), StringUtil.quotize(this.joinTable.alias), this.joinExpr.translateDB2(properties));
        }
        return String.format("%s %s ON (%s)", this.join, this.joinTable.translateDB2(properties), this.joinExpr.translateDB2(properties));
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        if (this.joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", this.join, this.joinTable.translateOracle(properties), StringUtil.quotize(this.joinTable.alias), this.joinExpr.translateOracle(properties));
        }
        return String.format("%s %s ON (%s)", this.join, this.joinTable.translateOracle(properties), this.joinExpr.translateOracle(properties));
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        if (this.joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", this.join, this.joinTable.translateMySQL(properties), StringUtil.quotize(this.joinTable.alias, "`"), this.joinExpr.translateMySQL(properties));
        }
        return String.format("%s %s ON (%s)", this.join, this.joinTable.translateMySQL(properties), this.joinExpr.translateMySQL(properties));
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        if (this.joinTable.isAliased()) {
            return String.format("%s %s %s %s ON (%s)", this.join, this.joinTable.translateSQLServer(properties), StringUtil.quotize(this.joinTable.alias), this.joinTable.isWithNoLock() ? " WITH(NOLOCK)" : "", this.joinExpr.translateSQLServer(properties));
        }
        return String.format("%s %s %s ON (%s)", this.join, this.joinTable.translateSQLServer(properties), this.joinTable.isWithNoLock() ? " WITH(NOLOCK)" : "", this.joinExpr.translateSQLServer(properties));
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        if (this.joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", this.join, this.joinTable.translatePostgreSQL(properties), StringUtil.quotize(this.joinTable.alias), this.joinExpr.translatePostgreSQL(properties));
        }
        return String.format("%s %s ON (%s)", this.join, this.joinTable.translatePostgreSQL(properties), this.joinExpr.translatePostgreSQL(properties));
    }

    @Override
    public String translateH2(PdbProperties properties) {
        if (this.joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", this.join, this.joinTable.translateH2(properties), StringUtil.quotize(this.joinTable.alias), this.joinExpr.translateH2(properties));
        }
        return String.format("%s %s ON (%s)", this.join, this.joinTable.translateH2(properties), this.joinExpr.translateH2(properties));
    }
}

