/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;

public class Function
extends Expression {
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String AVG = "AVG";
    public static final String COUNT = "COUNT";
    public static final String STDDEV = "STDDEV";
    public static final String SUM = "SUM";
    private String function;
    private Expression exp;

    public Function(String function) {
        this(function, null);
    }

    public Function(String function, Expression exp) {
        this.function = StringUtil.escapeSql(function);
        this.exp = exp;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        String exp = "";
        if (this.exp != null) {
            exp = this.exp.translateDB2(properties);
        }
        if (STDDEV.equalsIgnoreCase(this.function)) {
            return "SQRT(VARIANCE(" + exp + ")*COUNT(1)/(COUNT(1)-1))";
        }
        if (AVG.equalsIgnoreCase(this.function)) {
            return "AVG(" + exp + "+0.0)";
        }
        if (this.isUDF() && properties.existsSchema()) {
            return properties.getSchema() + "." + this.function + "(" + exp + ")";
        }
        return this.function + "(" + exp + ")";
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        String exp = "";
        if (this.exp != null) {
            exp = this.exp.translateOracle(properties);
        }
        if (this.isUDF() && properties.existsSchema()) {
            return properties.getSchema() + "." + this.function + "(" + exp + ")";
        }
        return this.function + "(" + exp + ")";
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        String function = this.function;
        String exp = "";
        if (this.exp != null) {
            exp = this.exp.translateMySQL(properties);
        }
        if (function.equals(STDDEV)) {
            function = "STDDEV_SAMP";
        }
        if (this.isUDF() && properties.existsSchema()) {
            return properties.getSchema() + "." + function + "(" + exp + ")";
        }
        return function + "(" + exp + ")";
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        String function = this.function;
        String exp = "";
        if (this.exp != null) {
            exp = this.exp.translateSQLServer(properties);
        }
        if (function.equals(STDDEV)) {
            function = "STDEV";
        }
        if (function.equals(AVG)) {
            exp = String.format("CONVERT(DOUBLE PRECISION, %s)", exp);
        }
        if (this.isUDF() && properties.existsSchema()) {
            return properties.getSchema() + "." + function + "(" + exp + ")";
        }
        return function + "(" + exp + ")";
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        String exp = "";
        if (this.exp != null) {
            exp = this.exp.translatePostgreSQL(properties);
        }
        if (this.isUDF() && properties.existsSchema()) {
            return properties.getSchema() + "." + this.function + "(" + exp + ")";
        }
        return this.function + "(" + exp + ")";
    }

    @Override
    public String translateH2(PdbProperties properties) {
        String exp = "";
        if (this.exp != null) {
            exp = this.exp.translateH2(properties);
        }
        if (this.function.equals(AVG)) {
            exp = String.format("CONVERT(%s, DOUBLE PRECISION)", exp);
        }
        if (this.isUDF() && properties.existsSchema()) {
            return properties.getSchema() + "." + this.function + "(" + exp + ")";
        }
        return this.function + "(" + exp + ")";
    }

    private boolean isUDF() {
        return !this.function.equals(MAX) && !this.function.equals(MIN) && !this.function.equals(AVG) && !this.function.equals(COUNT) && !this.function.equals(STDDEV) && !this.function.equals(SUM);
    }
}

