/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Expression
implements Serializable {
    protected String alias = null;
    protected boolean enclosed = false;
    protected boolean quotes = true;
    protected String ordering = null;
    protected final List<Join> joins = new ArrayList<Join>();
    protected boolean noLock = false;

    public String translate(Dialect diaclect, PdbProperties properties) {
        switch (diaclect) {
            case MYSQL: {
                return this.translateMySQL(properties);
            }
            case POSTGRESQL: {
                return this.translatePostgreSQL(properties);
            }
            case ORACLE: {
                return this.translateOracle(properties);
            }
            case SQLSERVER: {
                return this.translateSQLServer(properties);
            }
            case H2: {
                return this.translateH2(properties);
            }
            case DB2: {
                return this.translateDB2(properties);
            }
        }
        throw new DatabaseEngineRuntimeException("Unknown diaclect " + (Object)((Object)diaclect));
    }

    public abstract String translateDB2(PdbProperties var1);

    public abstract String translateOracle(PdbProperties var1);

    public abstract String translateMySQL(PdbProperties var1);

    public abstract String translateSQLServer(PdbProperties var1);

    public abstract String translatePostgreSQL(PdbProperties var1);

    public abstract String translateH2(PdbProperties var1);

    public Expression alias(String alias) {
        this.alias = alias;
        return this;
    }

    public Expression unquote() {
        this.quotes = false;
        return this;
    }

    public Expression enclose() {
        this.enclosed = true;
        return this;
    }

    public Expression asc() {
        this.ordering = "ASC";
        return this;
    }

    public Expression desc() {
        this.ordering = "DESC";
        return this;
    }

    public boolean isEnclosed() {
        return this.enclosed;
    }

    public boolean isQuote() {
        return this.quotes;
    }

    public boolean isAliased() {
        return this.alias != null;
    }

    public Expression innerJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("INNER JOIN", table, expr));
        return this;
    }

    public Expression leftOuterJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("LEFT OUTER JOIN", table, expr));
        return this;
    }

    public Expression rightOuterJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("RIGHT OUTER JOIN", table, expr));
        return this;
    }

    public Expression fullOuterJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("FULL OUTER JOIN", table, expr));
        return this;
    }

    public Expression withNoLock() {
        this.noLock = true;
        return this;
    }

    public boolean isWithNoLock() {
        return this.noLock;
    }
}

