/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import java.util.Arrays;

public class Coalesce
extends Expression {
    private final Expression exp;
    private final Expression[] alternative;

    public Coalesce(Expression exp, Expression ... alternative) {
        this.exp = exp;
        this.alternative = alternative;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        String[] alts = new String[this.alternative.length];
        int i = 0;
        for (Expression e : this.alternative) {
            alts[i] = e.translateDB2(properties);
            ++i;
        }
        return String.format("COALESCE(%s, " + StringUtil.join(Arrays.asList(alts), ", ") + ")", this.exp.translateDB2(properties));
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        String[] alts = new String[this.alternative.length];
        int i = 0;
        for (Expression e : this.alternative) {
            alts[i] = e.translateOracle(properties);
            ++i;
        }
        return String.format("COALESCE(%s, " + StringUtil.join(Arrays.asList(alts), ", ") + ")", this.exp.translateOracle(properties));
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        String[] alts = new String[this.alternative.length];
        int i = 0;
        for (Expression e : this.alternative) {
            alts[i] = e.translateMySQL(properties);
            ++i;
        }
        return String.format("COALESCE(%s, " + StringUtil.join(Arrays.asList(alts), ", ") + ")", this.exp.translateMySQL(properties));
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        String[] alts = new String[this.alternative.length];
        int i = 0;
        for (Expression e : this.alternative) {
            alts[i] = e.translateSQLServer(properties);
            ++i;
        }
        return String.format("COALESCE(%s, " + StringUtil.join(Arrays.asList(alts), ", ") + ")", this.exp.translateSQLServer(properties));
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        String[] alts = new String[this.alternative.length];
        int i = 0;
        for (Expression e : this.alternative) {
            alts[i] = e.translatePostgreSQL(properties);
            ++i;
        }
        return String.format("COALESCE(%s, " + StringUtil.join(Arrays.asList(alts), ", ") + ")", this.exp.translatePostgreSQL(properties));
    }

    @Override
    public String translateH2(PdbProperties properties) {
        String[] alts = new String[this.alternative.length];
        int i = 0;
        for (Expression e : this.alternative) {
            alts[i] = e.translateH2(properties);
            ++i;
        }
        return String.format("COALESCE(%s, " + StringUtil.join(Arrays.asList(alts), ", ") + ")", this.exp.translateH2(properties));
    }
}

