/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;

public class Between
extends Expression {
    private final Expression column;
    private final Expression and;
    private boolean not = false;

    public Between(Expression column, Expression exp) {
        this.column = column;
        this.and = exp;
    }

    public Between not() {
        this.not = true;
        return this;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        String modifier = "BETWEEN";
        if (this.not) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", this.column.translateDB2(properties), modifier, this.and.translateDB2(properties));
        if (this.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        String modifier = "BETWEEN";
        if (this.not) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", this.column.translateOracle(properties), modifier, this.and.translateOracle(properties));
        if (this.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        String modifier = "BETWEEN";
        if (this.not) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", this.column.translateMySQL(properties), modifier, this.and.translateMySQL(properties));
        if (this.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        String modifier = "BETWEEN";
        if (this.not) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", this.column.translateSQLServer(properties), modifier, this.and.translateSQLServer(properties));
        if (this.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        String modifier = "BETWEEN";
        if (this.not) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", this.column.translatePostgreSQL(properties), modifier, this.and.translatePostgreSQL(properties));
        if (this.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    @Override
    public String translateH2(PdbProperties properties) {
        String modifier = "BETWEEN";
        if (this.not) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", this.column.translateH2(properties), modifier, this.and.translateH2(properties));
        if (this.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }
}

