/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.MathUtil;
import com.feedzai.commons.sql.abstraction.util.StringUtil;

public class DropPrimaryKey
extends Expression {
    private final Expression table;

    public DropPrimaryKey(Expression table) {
        this.table = table;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        return String.format("ALTER TABLE %s DROP PRIMARY KEY", this.table.translateDB2(properties));
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        if (!(this.table instanceof Name)) {
            throw new DatabaseEngineRuntimeException("DropPrimaryKey must receive a Name object");
        }
        String tableName = ((Name)this.table).getName();
        String pkName = MathUtil.md5(String.format("PK_%s", tableName), properties.getMaxIdentifierSize());
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s", this.table.translatePostgreSQL(properties), StringUtil.quotize(pkName));
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        return String.format("ALTER TABLE %s DROP PRIMARY KEY", this.table.translateMySQL(properties));
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        if (!(this.table instanceof Name)) {
            throw new DatabaseEngineRuntimeException("DropPrimaryKey must receive a Name object");
        }
        String tableName = ((Name)this.table).getName();
        String pkName = MathUtil.md5(String.format("PK_%s", tableName), properties.getMaxIdentifierSize());
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s", this.table.translatePostgreSQL(properties), StringUtil.quotize(pkName));
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        if (!(this.table instanceof Name)) {
            throw new DatabaseEngineRuntimeException("DropPrimaryKey must receive a Name object");
        }
        String tableName = ((Name)this.table).getName();
        String pkName = MathUtil.md5(String.format("PK_%s", tableName), properties.getMaxIdentifierSize());
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s", this.table.translatePostgreSQL(properties), StringUtil.quotize(pkName));
    }

    @Override
    public String translateH2(PdbProperties properties) {
        return String.format("ALTER TABLE %s DROP PRIMARY KEY", this.table.translateH2(properties));
    }
}

