/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.K;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DbEntity
implements Serializable {
    private String name = null;
    private final List<DbColumn> columns = new ArrayList<DbColumn>();
    private final List<DbFk> fks = new ArrayList<DbFk>();
    private String[] pkFields = new String[0];
    private final List<DbIndex> indexes = new ArrayList<DbIndex>();

    public DbEntity setName(String name) {
        this.name = name;
        return this;
    }

    public DbEntity addColumn(DbColumn dbColumn) {
        this.columns.add(dbColumn);
        return this;
    }

    public DbEntity addColumn(Collection<DbColumn> dbColumn) {
        this.columns.addAll(dbColumn);
        return this;
    }

    public DbEntity addColumn(String name, DbColumnType type, DbColumnConstraint ... constraints) {
        this.addColumn(new DbColumn().setName(name).addConstraints(constraints).setType(type));
        return this;
    }

    public DbEntity addColumn(String name, DbColumnType type, Integer size, DbColumnConstraint ... constraints) {
        this.addColumn(new DbColumn().setName(name).addConstraints(constraints).setType(type).setSize(size));
        return this;
    }

    public DbEntity addColumn(String name, DbColumnType type, boolean autoInc, DbColumnConstraint ... constraints) {
        this.addColumn(new DbColumn().setName(name).addConstraints(constraints).setType(type).setAutoInc(autoInc));
        return this;
    }

    public DbEntity addColumn(String name, DbColumnType type, K defaultValue, DbColumnConstraint ... constraints) {
        this.addColumn(new DbColumn().setName(name).addConstraints(constraints).setType(type).setDefaultValue(defaultValue));
        return this;
    }

    public DbEntity addColumn(String name, DbColumnType type, Integer size, boolean autoInc, DbColumnConstraint ... constraints) {
        this.addColumn(new DbColumn().setName(name).addConstraints(constraints).setType(type).setAutoInc(autoInc).setSize(size));
        return this;
    }

    public void removeColumn(String name) {
        for (int x = 0; x < this.columns.size(); ++x) {
            if (!this.columns.get(x).getName().equals(name)) continue;
            this.columns.remove(x);
            return;
        }
    }

    public DbEntity setPkFields(String ... pkFields) {
        this.pkFields = pkFields;
        return this;
    }

    public DbEntity addIndex(DbIndex index) {
        this.indexes.add(index);
        return this;
    }

    public DbEntity addIndex(boolean unique, String ... columns) {
        return this.addIndex(new DbIndex().columns(columns).setUnique(unique));
    }

    public DbEntity addIndex(String ... columns) {
        return this.addIndex(false, columns);
    }

    public DbEntity addIndex(Collection<String> columns) {
        this.addIndex(new DbIndex().columns(columns));
        return this;
    }

    public DbEntity addFk(DbFk ... fks) {
        this.fks.addAll(Arrays.asList(fks));
        return this;
    }

    public DbEntity addFks(Collection<DbFk> fks) {
        this.fks.addAll(fks);
        return this;
    }

    public List<DbColumn> getColumns() {
        return this.columns;
    }

    public boolean containsColumn(String columnName) {
        for (DbColumn column : this.columns) {
            if (!column.getName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPkFields() {
        return this.pkFields;
    }

    public List<DbIndex> getIndexes() {
        return this.indexes;
    }

    public List<DbFk> getFks() {
        return this.fks;
    }
}

