/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.dml.K;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DbColumn
implements Serializable {
    private String name;
    private DbColumnType dbColumnType;
    private Integer size = null;
    private final List<DbColumnConstraint> columnConstraints = new ArrayList<DbColumnConstraint>();
    private boolean autoInc = false;
    private K defaultValue;

    public DbColumn() {
    }

    public DbColumn(String name, DbColumnType dbColumnType) {
        this(name, dbColumnType, false);
    }

    public DbColumn(String name, DbColumnType dbColumnType, boolean autoInc) {
        this.name = name;
        this.dbColumnType = dbColumnType;
        this.autoInc = autoInc;
    }

    public DbColumn(String name, DbColumnType dbColumnType, Integer size) {
        this.name = name;
        this.dbColumnType = dbColumnType;
        this.size = size;
    }

    public DbColumn(String name, DbColumnType dbColumnType, K defaultValue) {
        this.name = name;
        this.dbColumnType = dbColumnType;
        this.defaultValue = defaultValue;
    }

    public DbColumn setName(String name) {
        this.name = name;
        return this;
    }

    public DbColumn setSize(Integer size) {
        this.size = size;
        return this;
    }

    public DbColumn setType(DbColumnType dbColumnType) {
        this.dbColumnType = dbColumnType;
        return this;
    }

    public DbColumn addConstraint(DbColumnConstraint dbColumnConstraint) {
        this.columnConstraints.add(dbColumnConstraint);
        return this;
    }

    public DbColumn addConstraints(DbColumnConstraint ... constraints) {
        if (constraints == null) {
            return this;
        }
        this.columnConstraints.addAll(Arrays.asList(constraints));
        return this;
    }

    public DbColumn setAutoInc(boolean autoInc) {
        this.autoInc = autoInc;
        return this;
    }

    public boolean isAutoInc() {
        return this.autoInc;
    }

    public List<DbColumnConstraint> getColumnConstraints() {
        return this.columnConstraints;
    }

    public DbColumnType getDbColumnType() {
        return this.dbColumnType;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return this.size;
    }

    public boolean isSizeSet() {
        return this.size != null;
    }

    public K getDefaultValue() {
        return this.defaultValue;
    }

    public DbColumn setDefaultValue(K defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean isDefaultValueSet() {
        return this.defaultValue != null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.dbColumnType, this.size, this.columnConstraints, this.autoInc});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DbColumn other = (DbColumn)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.dbColumnType), (Object)((Object)other.dbColumnType)) && Objects.equal((Object)this.size, (Object)other.size) && Objects.equal(this.columnConstraints, other.columnConstraints) && Objects.equal((Object)this.autoInc, (Object)other.autoInc);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("dbColumnType", (Object)this.dbColumnType).add("size", (Object)this.size).add("columnConstraints", this.columnConstraints).add("autoInc", this.autoInc).add("defaultValue", (Object)this.defaultValue).toString();
    }
}

