/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtil;
import com.feedzai.commons.sql.abstraction.util.TypeTranslationUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;

public class AlterColumn
extends Expression {
    private final Expression table;
    private final DbColumn column;

    public AlterColumn(Expression table, DbColumn column) {
        this.table = table;
        this.column = column;
    }

    @Override
    public String translateDB2(PdbProperties properties) {
        StringBuilder sb = new StringBuilder();
        if (!this.column.getColumnConstraints().isEmpty()) {
            sb.append("ALTER TABLE ").append(this.table.translateDB2(properties)).append(" ALTER COLUMN ").append(new Name(this.column.getName()).translateDB2(properties)).append(" SET ");
            List trans = Lists.transform(this.column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

                public Object apply(DbColumnConstraint input) {
                    return input.translate();
                }
            });
            sb.append(StringUtil.join(trans, " ")).append('\u001f');
        }
        sb.append("ALTER TABLE ").append(this.table.translateDB2(properties)).append(" ALTER COLUMN ").append(new Name(this.column.getName()).translateDB2(properties)).append(" SET DATA TYPE ").append(TypeTranslationUtils.translateDB2Type(this.column, properties));
        return sb.toString();
    }

    @Override
    public String translateOracle(PdbProperties properties) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(this.table.translateOracle(properties)).append(" MODIFY (").append(new Name(this.column.getName()).translateOracle(properties)).append(" ").append(TypeTranslationUtils.translateOracleType(this.column, properties)).append(" ");
        List trans = Lists.transform(this.column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

            public Object apply(DbColumnConstraint input) {
                return input.translate();
            }
        });
        sb.append(StringUtil.join(trans, " "));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String translateMySQL(PdbProperties properties) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(this.table.translateMySQL(properties)).append(" MODIFY ").append(new Name(this.column.getName()).translateMySQL(properties)).append(" ").append(TypeTranslationUtils.translateMySqlType(this.column, properties)).append(" ");
        List trans = Lists.transform(this.column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

            public Object apply(DbColumnConstraint input) {
                return input.translate();
            }
        });
        sb.append(StringUtil.join(trans, " "));
        return sb.toString();
    }

    @Override
    public String translateSQLServer(PdbProperties properties) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(this.table.translateSQLServer(properties)).append(" ALTER COLUMN ").append(new Name(this.column.getName()).translateSQLServer(properties)).append(" ").append(TypeTranslationUtils.translateSqlServerType(this.column, properties)).append(" ");
        List trans = Lists.transform(this.column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

            public Object apply(DbColumnConstraint input) {
                return input.translate();
            }
        });
        sb.append(StringUtil.join(trans, " "));
        return sb.toString();
    }

    @Override
    public String translatePostgreSQL(PdbProperties properties) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(this.table.translatePostgreSQL(properties)).append(" ALTER COLUMN ").append(new Name(this.column.getName()).translatePostgreSQL(properties)).append(" TYPE ").append(TypeTranslationUtils.translatePostgreSqlType(this.column, properties)).append("; ");
        if (!this.column.getColumnConstraints().isEmpty()) {
            sb.append("ALTER TABLE ").append(this.table.translatePostgreSQL(properties)).append(" ALTER COLUMN ").append(new Name(this.column.getName()).translatePostgreSQL(properties)).append(" SET ");
            List trans = Lists.transform(this.column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

                public Object apply(DbColumnConstraint input) {
                    return input.translate();
                }
            });
            sb.append(StringUtil.join(trans, " "));
        }
        return sb.toString();
    }

    @Override
    public String translateH2(PdbProperties properties) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(this.table.translateH2(properties)).append(" ALTER COLUMN ").append(new Name(this.column.getName()).translateH2(properties)).append(" ").append(TypeTranslationUtils.translateH2Type(this.column, properties)).append(" ");
        List trans = Lists.transform(this.column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

            public Object apply(DbColumnConstraint input) {
                return input.translate();
            }
        });
        sb.append(StringUtil.join(trans, " "));
        return sb.toString();
    }
}

