/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.batch;

import com.feedzai.commons.sql.abstraction.batch.BatchEntry;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractBatch
extends TimerTask {
    protected final Logger logger = LoggerFactory.getLogger(AbstractBatch.class);
    protected static final Marker dev = MarkerFactory.getMarker((String)"DEV");
    protected static final int salt = 100;
    protected final DatabaseEngine de;
    protected final Timer timer;
    protected final int batchSize;
    protected final long batchTimeout;
    protected int batch;
    protected long lastFlush;
    protected LinkedList<BatchEntry> buffer = new LinkedList();

    protected AbstractBatch(DatabaseEngine de, int batchSize, long batchTimeout) {
        this.timer = new Timer();
        this.de = de;
        this.batchSize = batchSize;
        this.batch = batchSize;
        this.batchTimeout = batchTimeout;
        this.lastFlush = System.currentTimeMillis();
    }

    protected void start() {
        this.timer.scheduleAtFixedRate((TimerTask)this, 0L, this.batchTimeout + 100L);
    }

    public synchronized void destroy() {
        this.logger.trace("Destroy called on Batch");
        this.cancel();
        this.flush();
        this.timer.cancel();
        this.timer.purge();
    }

    public synchronized void add(BatchEntry batchEntry) throws DatabaseEngineException {
        this.buffer.add(batchEntry);
        --this.batch;
        if (this.batch == 0) {
            this.flush();
        }
    }

    public synchronized void add(String entityName, EntityEntry ee) throws DatabaseEngineException {
        this.add(new BatchEntry(entityName, ee));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        ArrayList<BatchEntry> temp = new ArrayList<BatchEntry>();
        try {
            long start = System.currentTimeMillis();
            while (!this.buffer.isEmpty()) {
                BatchEntry entry = this.buffer.poll();
                temp.add(entry);
                this.de.addBatch(entry.getTableName(), entry.getEntityEntry());
            }
            this.de.beginTransaction();
            try {
                this.de.flush();
                this.de.commit();
                this.logger.trace("Batch flushed. Took {} ms, {} rows ", (Object)(System.currentTimeMillis() - start), (Object)(this.batchSize - this.batch));
                this.batch = this.batchSize;
                this.lastFlush = System.currentTimeMillis();
            }
            finally {
                if (this.de.isTransactionActive()) {
                    this.de.rollback();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(dev, "Error occurred while flushing.", (Throwable)e);
            this.onFlushFailure(temp.toArray(new BatchEntry[0]));
        }
    }

    public void onFlushFailure(BatchEntry[] entries) {
    }

    @Override
    public synchronized void run() {
        if (System.currentTimeMillis() - this.lastFlush >= this.batchTimeout && this.batch != this.batchSize) {
            this.logger.trace("Flush timeout occurred");
            this.flush();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.logger.trace(this + " died");
    }
}

