/*
 * Decompiled with CFR 0.152.
 */
package com.fede987.statusbaralert;

import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.fede987.statusbaralert.StatusBarAlert;
import com.fede987.statusbaralert.utils.ScreenUtilsKt;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012Jc\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010!\u001a\u00020\u001fJ\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001fH\u0014J\u0006\u0010%\u001a\u00020\u001fJ\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u0007R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/fede987/statusbaralert/StatusBarAlertView;", "Landroid/widget/LinearLayout;", "any", "Landroid/app/Activity;", "alertColor", "", "stringText", "", "text", "textColor", "typeface", "Landroid/graphics/Typeface;", "showProgress", "", "indeterminateProgressBarColor", "autohide", "autohideDuration", "", "(Landroid/app/Activity;ILjava/lang/String;Ljava/lang/Integer;ILandroid/graphics/Typeface;ZIZJ)V", "autohideRunnable", "Ljava/lang/Runnable;", "progressBar", "Landroid/widget/ProgressBar;", "statusBarColorOringinal", "getStatusBarColorOringinal", "()I", "setStatusBarColorOringinal", "(I)V", "textView", "Landroid/widget/TextView;", "buildUI", "", "typeFace", "hideIndeterminateProgress", "observeLifecycle", "Landroid/content/Context;", "onDetachedFromWindow", "showIndeterminateProgress", "updateText", "status-bar-alert_release"})
@SuppressLint(value={"ViewConstructor"})
public final class StatusBarAlertView
extends LinearLayout {
    private int statusBarColorOringinal;
    private TextView textView;
    private ProgressBar progressBar;
    private Runnable autohideRunnable;
    private HashMap _$_findViewCache;

    public final int getStatusBarColorOringinal() {
        return this.statusBarColorOringinal;
    }

    public final void setStatusBarColorOringinal(int n) {
        this.statusBarColorOringinal = n;
    }

    private final void observeLifecycle(Context any) {
        if (any instanceof AppCompatActivity) {
            ((AppCompatActivity)any).getLifecycle().addObserver(new LifecycleObserver(any){
                final /* synthetic */ Context $any;

                @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                public final void destroy() {
                    StatusBarAlert.Companion.hide$default(StatusBarAlert.Companion, (Activity)this.$any, null, 2, null);
                    ((AppCompatActivity)this.$any).getLifecycle().removeObserver((LifecycleObserver)this);
                }
                {
                    this.$any = $captured_local_variable$0;
                }
            });
        }
    }

    private final void buildUI(Activity any, int alertColor, String stringText, Integer text, int textColor, Typeface typeFace, boolean showProgress, int indeterminateProgressBarColor, boolean autohide, long autohideDuration) {
        boolean isLollipop = Build.VERSION.SDK_INT >= 21;
        Activity activity = any;
        if (!(activity instanceof Activity)) {
            activity = null;
        }
        Intrinsics.checkNotNull((Object)activity);
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"(any as? Activity)!!.window");
        View view = window.getDecorView();
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup decorView = (ViewGroup)view;
        int statusBarHeight = ScreenUtilsKt.getStatusBarHeight(any) * (isLollipop ? 1 : 2);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, statusBarHeight));
        this.setGravity(1);
        LinearLayout wrapper = new LinearLayout((Context)any);
        wrapper.setOrientation(0);
        wrapper.setGravity(17);
        wrapper.setLayoutParams(new ViewGroup.LayoutParams(-1, statusBarHeight));
        wrapper.setPadding(0, isLollipop ? 0 : statusBarHeight / 2, 0, 0);
        if (alertColor > 0) {
            wrapper.setBackgroundColor(ContextCompat.getColor((Context)((Context)any), (int)alertColor));
        }
        TextView textView = this.textView = new TextView((Context)any);
        Intrinsics.checkNotNull((Object)textView);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, statusBarHeight));
        TextView textView2 = this.textView;
        Intrinsics.checkNotNull((Object)textView2);
        textView2.setTextSize(11.0f);
        TextView textView3 = this.textView;
        Intrinsics.checkNotNull((Object)textView3);
        textView3.setTextColor(-1);
        TextView textView4 = this.textView;
        Intrinsics.checkNotNull((Object)textView4);
        textView4.setGravity(17);
        if (text != null) {
            TextView textView5 = this.textView;
            if (textView5 != null) {
                textView5.setText(text != 0 ? (CharSequence)(any.getResources().getString(text.intValue()) + " ") : (CharSequence)(Intrinsics.areEqual((Object)stringText, (Object)"") ^ true ? stringText + ' ' : ""));
            }
        }
        if (textColor > 0) {
            TextView textView6 = this.textView;
            Intrinsics.checkNotNull((Object)textView6);
            textView6.setTextColor(ContextCompat.getColor((Context)((Context)any), (int)textColor));
        }
        TextView textView7 = this.textView;
        Intrinsics.checkNotNull((Object)textView7);
        textView7.setIncludeFontPadding(false);
        Typeface typeface = typeFace;
        if (typeface != null) {
            Typeface typeface2 = typeface;
            boolean bl = false;
            boolean bl2 = false;
            Typeface it = typeface2;
            boolean bl3 = false;
            TextView textView8 = this.textView;
            if (textView8 != null) {
                textView8.setTypeface(it);
            }
        }
        wrapper.addView((View)this.textView);
        this.progressBar = new ProgressBar((Context)any);
        if (indeterminateProgressBarColor > 0) {
            if (isLollipop) {
                ProgressBar progressBar = this.progressBar;
                Intrinsics.checkNotNull((Object)progressBar);
                progressBar.setIndeterminateTintMode(PorterDuff.Mode.SRC_IN);
                ProgressBar progressBar2 = this.progressBar;
                Intrinsics.checkNotNull((Object)progressBar2);
                progressBar2.setIndeterminateTintList(ColorStateList.valueOf((int)ContextCompat.getColor((Context)((Context)any), (int)indeterminateProgressBarColor)));
            } else {
                ProgressBar progressBar = this.progressBar;
                Intrinsics.checkNotNull((Object)progressBar);
                progressBar.getIndeterminateDrawable().setColorFilter(ContextCompat.getColor((Context)((Context)any), (int)indeterminateProgressBarColor), PorterDuff.Mode.SRC_IN);
            }
        }
        ProgressBar progressBar = this.progressBar;
        Intrinsics.checkNotNull((Object)progressBar);
        progressBar.setIndeterminate(true);
        int textSize = ScreenUtilsKt.convertDpToPixel(any, 11.0f);
        ProgressBar progressBar3 = this.progressBar;
        Intrinsics.checkNotNull((Object)progressBar3);
        progressBar3.setLayoutParams(new ViewGroup.LayoutParams(textSize, textSize));
        wrapper.addView((View)this.progressBar);
        if (showProgress) {
            ProgressBar progressBar4 = this.progressBar;
            if (progressBar4 != null) {
                progressBar4.setVisibility(0);
            }
        } else {
            ProgressBar progressBar5 = this.progressBar;
            if (progressBar5 != null) {
                progressBar5.setVisibility(8);
            }
        }
        this.addView((View)wrapper);
        int lowProfileSystemUIVisibility = decorView.getSystemUiVisibility() | 1;
        decorView.setSystemUiVisibility(lowProfileSystemUIVisibility);
        decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(this, lowProfileSystemUIVisibility){
            final /* synthetic */ StatusBarAlertView this$0;
            final /* synthetic */ int $lowProfileSystemUIVisibility;

            public final void onSystemUiVisibilityChange(int $noName_0) {
                this.this$0.setSystemUiVisibility(this.$lowProfileSystemUIVisibility);
            }
            {
                this.this$0 = statusBarAlertView;
                this.$lowProfileSystemUIVisibility = n;
            }
        });
        if (isLollipop) {
            Window window2 = any.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"any.window");
            this.statusBarColorOringinal = window2.getStatusBarColor();
        }
        decorView.addView((View)this);
        wrapper.setTranslationY(-((float)statusBarHeight));
        ViewPropertyAnimator viewPropertyAnimator = wrapper.animate();
        Intrinsics.checkNotNull((Object)viewPropertyAnimator);
        viewPropertyAnimator.translationY(0.0f).setDuration((long)any.getResources().getInteger(0x10E0000)).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).start();
        if (autohide) {
            this.autohideRunnable = new Runnable(any){
                final /* synthetic */ Activity $any;

                public final void run() {
                    StatusBarAlert.Companion.hide$default(StatusBarAlert.Companion, this.$any, null, 2, null);
                    ComponentName componentName = this.$any.getComponentName();
                    Intrinsics.checkNotNullExpressionValue((Object)componentName, (String)"any.componentName");
                    StatusBarAlert.allAlerts.remove(componentName.getClassName());
                }
                {
                    this.$any = activity;
                }
            };
            this.postDelayed(this.autohideRunnable, autohideDuration);
        }
    }

    protected void onDetachedFromWindow() {
        Runnable runnable = this.autohideRunnable;
        if (runnable != null) {
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            this.removeCallbacks(it);
        }
        this.autohideRunnable = null;
        Context context = this.getContext();
        if (context == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
        }
        Window window = ((Activity)context).getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"(context as Activity).window");
        window.getDecorView().setOnSystemUiVisibilityChangeListener(null);
        super.onDetachedFromWindow();
    }

    public final void updateText(@NotNull String text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            TextView textView = this.textView;
            if (textView == null) break block0;
            textView.setText((CharSequence)(text + ' '));
        }
    }

    public final void updateText(int text) {
        block0: {
            TextView textView = this.textView;
            if (textView == null) break block0;
            StringBuilder stringBuilder = new StringBuilder();
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            textView.setText((CharSequence)stringBuilder.append(context.getResources().getString(text)).append(' ').toString());
        }
    }

    public final void showIndeterminateProgress() {
        block0: {
            ProgressBar progressBar = this.progressBar;
            if (progressBar == null) break block0;
            progressBar.setVisibility(0);
        }
    }

    public final void hideIndeterminateProgress() {
        block0: {
            ProgressBar progressBar = this.progressBar;
            if (progressBar == null) break block0;
            progressBar.setVisibility(8);
        }
    }

    public StatusBarAlertView(@NotNull Activity any, int alertColor, @Nullable String stringText, @Nullable Integer text, int textColor, @Nullable Typeface typeface, boolean showProgress, int indeterminateProgressBarColor, boolean autohide, long autohideDuration) {
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        super((Context)any, null, 0);
        this.observeLifecycle((Context)any);
        this.buildUI(any, alertColor, stringText, text, textColor, typeface, showProgress, indeterminateProgressBarColor, autohide, autohideDuration);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

