/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.javaluator;

import com.fathzer.soft.javaluator.AbstractVariableSet;
import com.fathzer.soft.javaluator.BracketPair;
import com.fathzer.soft.javaluator.Constant;
import com.fathzer.soft.javaluator.Function;
import com.fathzer.soft.javaluator.Operator;
import com.fathzer.soft.javaluator.Parameters;
import com.fathzer.soft.javaluator.Token;
import com.fathzer.soft.javaluator.Tokenizer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractEvaluator<T> {
    private final Tokenizer tokenizer;
    private final Map<String, Function> functions;
    private final Map<String, List<Operator>> operators;
    private final Map<String, Constant> constants;
    private final String functionArgumentSeparator;
    private final Map<String, BracketPair> functionBrackets;
    private final Map<String, BracketPair> expressionBrackets;

    protected AbstractEvaluator(Parameters parameters) {
        ArrayList<String> tokenDelimitersBuilder = new ArrayList<String>();
        this.functions = new HashMap<String, Function>();
        this.operators = new HashMap<String, List<Operator>>();
        this.constants = new HashMap<String, Constant>();
        this.functionBrackets = new HashMap<String, BracketPair>();
        for (BracketPair pair : parameters.getFunctionBrackets()) {
            this.functionBrackets.put(pair.getOpen(), pair);
            this.functionBrackets.put(pair.getClose(), pair);
            tokenDelimitersBuilder.add(pair.getOpen());
            tokenDelimitersBuilder.add(pair.getClose());
        }
        this.expressionBrackets = new HashMap<String, BracketPair>();
        for (BracketPair pair : parameters.getExpressionBrackets()) {
            this.expressionBrackets.put(pair.getOpen(), pair);
            this.expressionBrackets.put(pair.getClose(), pair);
            tokenDelimitersBuilder.add(pair.getOpen());
            tokenDelimitersBuilder.add(pair.getClose());
        }
        if (this.operators != null) {
            for (Operator ope : parameters.getOperators()) {
                tokenDelimitersBuilder.add(ope.getSymbol());
                List<Operator> known = this.operators.get(ope.getSymbol());
                if (known == null) {
                    known = new ArrayList<Operator>();
                    this.operators.put(ope.getSymbol(), known);
                }
                known.add(ope);
                if (known.size() <= 1) continue;
                this.validateHomonyms(known);
            }
        }
        boolean needFunctionSeparator = false;
        if (parameters.getFunctions() != null) {
            for (Function function : parameters.getFunctions()) {
                this.functions.put(parameters.getTranslation(function.getName()), function);
                if (function.getMaximumArgumentCount() <= 1) continue;
                needFunctionSeparator = true;
            }
        }
        if (parameters.getConstants() != null) {
            for (Constant constant : parameters.getConstants()) {
                this.constants.put(parameters.getTranslation(constant.getName()), constant);
            }
        }
        this.functionArgumentSeparator = parameters.getFunctionArgumentSeparator();
        if (needFunctionSeparator) {
            tokenDelimitersBuilder.add(this.functionArgumentSeparator);
        }
        this.tokenizer = new Tokenizer(tokenDelimitersBuilder);
    }

    protected void validateHomonyms(List<Operator> operators) {
        if (operators.size() > 2) {
            throw new IllegalArgumentException();
        }
    }

    protected Operator guessOperator(Token previous, List<Operator> candidates) {
        int argCount = previous != null && (previous.isCloseBracket() || previous.isLiteral()) ? 2 : 1;
        for (Operator operator : candidates) {
            if (operator.getOperandCount() != argCount) continue;
            return operator;
        }
        return null;
    }

    private void output(Deque<T> values, Token token, Object evaluationContext) {
        if (token.isLiteral()) {
            Object value;
            String literal = token.getLiteral();
            Constant ct = this.constants.get(literal);
            Object e = value = ct == null ? null : (Object)this.evaluate(ct, evaluationContext);
            if (value == null && evaluationContext != null && evaluationContext instanceof AbstractVariableSet) {
                value = ((AbstractVariableSet)evaluationContext).get(literal);
            }
            values.push(value != null ? value : (Object)this.toValue(literal, evaluationContext));
        } else if (token.isOperator()) {
            Operator operator = token.getOperator();
            values.push(this.evaluate(operator, this.getArguments(values, operator.getOperandCount()), evaluationContext));
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected T evaluate(Constant constant, Object evaluationContext) {
        throw new UnsupportedOperationException("evaluate(Constant) is not implemented for " + constant.getName());
    }

    protected T evaluate(Operator operator, Iterator<T> operands, Object evaluationContext) {
        throw new UnsupportedOperationException("evaluate(Operator, Iterator) is not implemented for " + operator.getSymbol());
    }

    protected T evaluate(Function function, Iterator<T> arguments, Object evaluationContext) {
        throw new UnsupportedOperationException("evaluate(Function, Iterator) is not implemented for " + function.getName());
    }

    private void doFunction(Deque<T> values, Function function, int argCount, Object evaluationContext) {
        if (function.getMinimumArgumentCount() > argCount || function.getMaximumArgumentCount() < argCount) {
            throw new IllegalArgumentException("Invalid argument count for " + function.getName());
        }
        values.push(this.evaluate(function, this.getArguments(values, argCount), evaluationContext));
    }

    private Iterator<T> getArguments(Deque<T> values, int nb) {
        if (values.size() < nb) {
            throw new IllegalArgumentException();
        }
        LinkedList<T> result = new LinkedList<T>();
        for (int i = 0; i < nb; ++i) {
            result.addFirst(values.pop());
        }
        return result.iterator();
    }

    protected abstract T toValue(String var1, Object var2);

    public T evaluate(String expression) {
        return this.evaluate(expression, null);
    }

    public T evaluate(String expression, Object evaluationContext) {
        ArrayDeque values = new ArrayDeque();
        ArrayDeque<Token> stack = new ArrayDeque<Token>();
        ArrayDeque<Integer> previousValuesSize = this.functions.isEmpty() ? null : new ArrayDeque<Integer>();
        Iterator<String> tokens = this.tokenize(expression);
        Token previous = null;
        while (tokens.hasNext()) {
            String strToken = tokens.next();
            Token token = this.toToken(previous, strToken);
            if (token.isOpenBracket()) {
                stack.push(token);
                if (previous != null && previous.isFunction()) {
                    if (!this.functionBrackets.containsKey(token.getBrackets().getOpen())) {
                        throw new IllegalArgumentException("Invalid bracket after function: " + strToken);
                    }
                } else if (!this.expressionBrackets.containsKey(token.getBrackets().getOpen())) {
                    throw new IllegalArgumentException("Invalid bracket in expression: " + strToken);
                }
            } else if (token.isCloseBracket()) {
                if (previous == null) {
                    throw new IllegalArgumentException("expression can't start with a close bracket");
                }
                if (previous.isFunctionArgumentSeparator()) {
                    throw new IllegalArgumentException("argument is missing");
                }
                BracketPair brackets = token.getBrackets();
                boolean openBracketFound = false;
                while (!stack.isEmpty()) {
                    Token sc = (Token)stack.pop();
                    if (sc.isOpenBracket()) {
                        if (sc.getBrackets().equals(brackets)) {
                            openBracketFound = true;
                            break;
                        }
                        throw new IllegalArgumentException("Invalid parenthesis match " + sc.getBrackets().getOpen() + brackets.getClose());
                    }
                    this.output(values, sc, evaluationContext);
                }
                if (!openBracketFound) {
                    throw new IllegalArgumentException("Parentheses mismatched");
                }
                if (!stack.isEmpty() && ((Token)stack.peek()).isFunction()) {
                    int argCount = values.size() - (Integer)previousValuesSize.pop();
                    this.doFunction(values, ((Token)stack.pop()).getFunction(), argCount, evaluationContext);
                }
            } else if (token.isFunctionArgumentSeparator()) {
                if (previous == null) {
                    throw new IllegalArgumentException("expression can't start with a function argument separator");
                }
                if (previous.isOpenBracket() || previous.isFunctionArgumentSeparator()) {
                    throw new IllegalArgumentException("argument is missing");
                }
                boolean pe = false;
                while (!stack.isEmpty()) {
                    if (((Token)stack.peek()).isOpenBracket()) {
                        pe = true;
                        break;
                    }
                    this.output(values, (Token)stack.pop(), evaluationContext);
                }
                if (!pe) {
                    throw new IllegalArgumentException("Separator or parentheses mismatched");
                }
                Token openBracket = (Token)stack.pop();
                Token scopeToken = (Token)stack.peek();
                stack.push(openBracket);
                if (!scopeToken.isFunction()) {
                    throw new IllegalArgumentException("Argument separator used outside of function scope");
                }
            } else if (token.isFunction()) {
                stack.push(token);
                previousValuesSize.push(values.size());
            } else if (token.isOperator()) {
                Token sc;
                while (!stack.isEmpty() && (sc = (Token)stack.peek()).isOperator() && (token.getAssociativity().equals((Object)Operator.Associativity.LEFT) && token.getPrecedence() <= sc.getPrecedence() || token.getPrecedence() < sc.getPrecedence())) {
                    this.output(values, (Token)stack.pop(), evaluationContext);
                }
                stack.push(token);
            } else {
                if (previous != null && previous.isLiteral()) {
                    throw new IllegalArgumentException("A literal can't follow another literal");
                }
                this.output(values, token, evaluationContext);
            }
            previous = token;
        }
        while (!stack.isEmpty()) {
            Token sc = (Token)stack.pop();
            if (sc.isOpenBracket() || sc.isCloseBracket()) {
                throw new IllegalArgumentException("Parentheses mismatched");
            }
            this.output(values, sc, evaluationContext);
        }
        if (values.size() != 1) {
            throw new IllegalArgumentException();
        }
        return (T)values.pop();
    }

    private Token toToken(Token previous, String token) {
        if (token.equals(this.functionArgumentSeparator)) {
            return Token.FUNCTION_ARG_SEPARATOR;
        }
        if (this.functions.containsKey(token)) {
            return Token.buildFunction(this.functions.get(token));
        }
        if (this.operators.containsKey(token)) {
            List<Operator> list = this.operators.get(token);
            return list.size() == 1 ? Token.buildOperator(list.get(0)) : Token.buildOperator(this.guessOperator(previous, list));
        }
        BracketPair brackets = this.getBracketPair(token);
        if (brackets != null) {
            if (brackets.getOpen().equals(token)) {
                return Token.buildOpenToken(brackets);
            }
            return Token.buildCloseToken(brackets);
        }
        return Token.buildLiteral(token);
    }

    private BracketPair getBracketPair(String token) {
        BracketPair result = this.expressionBrackets.get(token);
        return result == null ? this.functionBrackets.get(token) : result;
    }

    public Collection<Operator> getOperators() {
        ArrayList<Operator> result = new ArrayList<Operator>();
        Collection<List<Operator>> values = this.operators.values();
        for (List<Operator> list : values) {
            result.addAll(list);
        }
        return result;
    }

    public Collection<Function> getFunctions() {
        return this.functions.values();
    }

    public Collection<Constant> getConstants() {
        return this.constants.values();
    }

    protected Iterator<String> tokenize(String expression) {
        return this.tokenizer.tokenize(expression);
    }
}

