/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort.std;

import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.Sorter;
import com.fasterxml.sort.std.ByteArrayComparator;
import com.fasterxml.sort.std.RawTextLineReader;
import com.fasterxml.sort.std.RawTextLineWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class TextFileSorter
extends Sorter<byte[]> {
    public static final long MAX_HEAP_FOR_PRESORT = 0x10000000L;
    public static final long MIN_HEAP_FOR_PRESORT = 0xA00000L;

    public TextFileSorter() {
        this(new SortConfig());
    }

    public TextFileSorter(SortConfig config) {
        super(config, RawTextLineReader.factory(), RawTextLineWriter.factory(), new ByteArrayComparator());
    }

    public static void main(String[] args) throws Exception {
        InputStream in;
        long availMem;
        long maxMem;
        if (args.length > 1) {
            System.err.println("Usage: java " + TextFileSorter.class.getName() + " [input-file]");
            System.err.println("(where input-file is optional; if missing, read from STDIN)");
            System.exit(1);
        }
        if ((maxMem = (availMem = Runtime.getRuntime().maxMemory() - 0x2800000L) >> 1) > 0x10000000L) {
            maxMem = 0x10000000L;
        } else if (maxMem < 0xA00000L) {
            maxMem = 0xA00000L;
        }
        final TextFileSorter sorter = new TextFileSorter(new SortConfig().withMaxMemoryUsage(maxMem));
        if (args.length == 0) {
            in = System.in;
        } else {
            File input = new File(args[0]);
            if (!input.exists() || input.isDirectory()) {
                System.err.println("File '" + input.getAbsolutePath() + "' does not exist (or is not file)");
                System.exit(2);
            }
            in = new FileInputStream(input);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    while (!sorter.isCompleted()) {
                        Thread.sleep(5000L);
                        if (sorter.isPreSorting()) {
                            System.err.printf(" pre-sorting: %d files written\n", sorter.getNumberOfPreSortFiles());
                            continue;
                        }
                        if (!sorter.isSorting()) continue;
                        System.err.printf(" sorting, round: %d/%d\n", sorter.getSortRound(), sorter.getNumberOfSortRounds());
                    }
                    double secs = (double)(System.currentTimeMillis() - start) / 1000.0;
                    System.err.printf("Completed: took %.1f seconds.\n", secs);
                }
                catch (InterruptedException e) {
                    double secs = (double)(System.currentTimeMillis() - start) / 1000.0;
                    System.err.printf("[INTERRUPTED] -- took %.1f seconds.\n", secs);
                }
            }
        }).start();
        sorter.sort(in, System.out);
        sorter.close();
    }
}

