/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BeanUtil {
    protected static boolean isConcrete(Member member) {
        int mod = member.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore) {
        return BeanUtil.findSuperTypes(cls, endBefore, new ArrayList());
    }

    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore, List<Class<?>> result) {
        BeanUtil._addSuperTypes(cls, endBefore, result, false);
        return result;
    }

    private static void _addSuperTypes(Class<?> cls, Class<?> endBefore, Collection<Class<?>> result, boolean addClassItself) {
        if (cls == endBefore || cls == null || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result.contains(cls)) {
                return;
            }
            result.add(cls);
        }
        for (Class<?> intCls : cls.getInterfaces()) {
            BeanUtil._addSuperTypes(intCls, endBefore, result, true);
        }
        BeanUtil._addSuperTypes(cls.getSuperclass(), endBefore, result, true);
    }
}

