/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.fasterxml.jackson.module.kotlin.GenericValueClassUnboxConverter;
import com.fasterxml.jackson.module.kotlin.IntValueClassUnboxConverter;
import com.fasterxml.jackson.module.kotlin.JavaUuidValueClassUnboxConverter;
import com.fasterxml.jackson.module.kotlin.LongValueClassUnboxConverter;
import com.fasterxml.jackson.module.kotlin.StringValueClassUnboxConverter;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u0002*\n\b\u0001\u0010\u0003*\u0004\u0018\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001\u001eB\t\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u0082\u0001\u0005\u001f !\"#\u00a8\u0006$"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ValueClassUnboxConverter;", "S", "", "D", "Lcom/fasterxml/jackson/databind/util/StdConverter;", "<init>", "()V", "valueClass", "Ljava/lang/Class;", "getValueClass", "()Ljava/lang/Class;", "unboxedType", "Ljava/lang/reflect/Type;", "getUnboxedType", "()Ljava/lang/reflect/Type;", "unboxHandle", "Ljava/lang/invoke/MethodHandle;", "getUnboxHandle", "()Ljava/lang/invoke/MethodHandle;", "getInputType", "Lcom/fasterxml/jackson/databind/JavaType;", "typeFactory", "Lcom/fasterxml/jackson/databind/type/TypeFactory;", "getOutputType", "delegatingSerializer", "Lcom/fasterxml/jackson/databind/ser/std/StdDelegatingSerializer;", "getDelegatingSerializer", "()Lcom/fasterxml/jackson/databind/ser/std/StdDelegatingSerializer;", "delegatingSerializer$delegate", "Lkotlin/Lazy;", "Companion", "Lcom/fasterxml/jackson/module/kotlin/GenericValueClassUnboxConverter;", "Lcom/fasterxml/jackson/module/kotlin/IntValueClassUnboxConverter;", "Lcom/fasterxml/jackson/module/kotlin/JavaUuidValueClassUnboxConverter;", "Lcom/fasterxml/jackson/module/kotlin/LongValueClassUnboxConverter;", "Lcom/fasterxml/jackson/module/kotlin/StringValueClassUnboxConverter;", "jackson-module-kotlin"})
public abstract class ValueClassUnboxConverter<S, D>
extends StdConverter<S, D> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy delegatingSerializer$delegate = LazyKt.lazy(() -> ValueClassUnboxConverter.delegatingSerializer_delegate$lambda$0(this));

    private ValueClassUnboxConverter() {
    }

    @NotNull
    public abstract Class<S> getValueClass();

    @NotNull
    public abstract Type getUnboxedType();

    @NotNull
    public abstract MethodHandle getUnboxHandle();

    @NotNull
    public final JavaType getInputType(@NotNull TypeFactory typeFactory) {
        Intrinsics.checkNotNullParameter((Object)typeFactory, (String)"typeFactory");
        JavaType javaType = typeFactory.constructType((Type)this.getValueClass());
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructType(...)");
        return javaType;
    }

    @NotNull
    public final JavaType getOutputType(@NotNull TypeFactory typeFactory) {
        Intrinsics.checkNotNullParameter((Object)typeFactory, (String)"typeFactory");
        JavaType javaType = typeFactory.constructType(this.getUnboxedType());
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructType(...)");
        return javaType;
    }

    @NotNull
    public final StdDelegatingSerializer getDelegatingSerializer() {
        Lazy lazy = this.delegatingSerializer$delegate;
        return (StdDelegatingSerializer)lazy.getValue();
    }

    private static final StdDelegatingSerializer delegatingSerializer_delegate$lambda$0(ValueClassUnboxConverter this$0) {
        return new StdDelegatingSerializer((Converter)this$0);
    }

    public /* synthetic */ ValueClassUnboxConverter(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\b"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ValueClassUnboxConverter$Companion;", "", "<init>", "()V", "create", "Lcom/fasterxml/jackson/module/kotlin/ValueClassUnboxConverter;", "valueClass", "Ljava/lang/Class;", "jackson-module-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ValueClassUnboxConverter<?, ?> create(@NotNull Class<?> valueClass) {
            ValueClassUnboxConverter valueClassUnboxConverter;
            Type unboxedType;
            Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
            Method unboxMethod = valueClass.getDeclaredMethod("unbox-impl", new Class[0]);
            Type type = unboxedType = unboxMethod.getGenericReturnType();
            if (Intrinsics.areEqual((Object)type, Integer.TYPE)) {
                Intrinsics.checkNotNull((Object)unboxMethod);
                valueClassUnboxConverter = new IntValueClassUnboxConverter(valueClass, unboxMethod);
            } else if (Intrinsics.areEqual((Object)type, Long.TYPE)) {
                Intrinsics.checkNotNull((Object)unboxMethod);
                valueClassUnboxConverter = new LongValueClassUnboxConverter(valueClass, unboxMethod);
            } else if (Intrinsics.areEqual((Object)type, String.class)) {
                Intrinsics.checkNotNull((Object)unboxMethod);
                valueClassUnboxConverter = new StringValueClassUnboxConverter(valueClass, unboxMethod);
            } else if (Intrinsics.areEqual((Object)type, UUID.class)) {
                Intrinsics.checkNotNull((Object)unboxMethod);
                valueClassUnboxConverter = new JavaUuidValueClassUnboxConverter(valueClass, unboxMethod);
            } else {
                Intrinsics.checkNotNull((Object)unboxedType);
                Intrinsics.checkNotNull((Object)unboxMethod);
                valueClassUnboxConverter = new GenericValueClassUnboxConverter(valueClass, unboxedType, unboxMethod);
            }
            return valueClassUnboxConverter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

