/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.module.kotlin.InternalCommonsKt;
import com.fasterxml.jackson.module.kotlin.ReflectionCache;
import com.fasterxml.jackson.module.kotlin.ValueClassStaticJsonKeySerializer;
import com.fasterxml.jackson.module.kotlin.ValueClassUnboxConverter;
import com.fasterxml.jackson.module.kotlin.ValueClassUnboxKeySerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinKeySerializers;", "Lcom/fasterxml/jackson/databind/ser/Serializers$Base;", "cache", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "<init>", "(Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;)V", "findSerializer", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "config", "Lcom/fasterxml/jackson/databind/SerializationConfig;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
public final class KotlinKeySerializers
extends Serializers.Base {
    @NotNull
    private final ReflectionCache cache;

    public KotlinKeySerializers(@NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
    }

    @Nullable
    public JsonSerializer<?> findSerializer(@NotNull SerializationConfig config, @NotNull JavaType type, @NotNull BeanDescription beanDesc) {
        JsonSerializer jsonSerializer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDesc, (String)"beanDesc");
        Class rawClass = type.getRawClass();
        Intrinsics.checkNotNull((Object)rawClass);
        if (InternalCommonsKt.isUnboxableValueClass(rawClass)) {
            ValueClassUnboxConverter<?, ?> unboxConverter = this.cache.getValueClassUnboxConverter(rawClass);
            ValueClassStaticJsonKeySerializer<?> valueClassStaticJsonKeySerializer = ValueClassStaticJsonKeySerializer.Companion.createOrNull(unboxConverter);
            jsonSerializer = (JsonSerializer)(valueClassStaticJsonKeySerializer != null ? (StdSerializer)valueClassStaticJsonKeySerializer : (StdSerializer)new ValueClassUnboxKeySerializer(unboxConverter));
        } else {
            jsonSerializer = null;
        }
        return jsonSerializer;
    }
}

