/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.module.kotlin.GenericValueClassBoxConverter;
import com.fasterxml.jackson.module.kotlin.HasConversionCreatorWrapsSpecifiedBoxDeserializer;
import com.fasterxml.jackson.module.kotlin.InternalCommonsKt;
import com.fasterxml.jackson.module.kotlin.JavaToKotlinDurationConverter;
import com.fasterxml.jackson.module.kotlin.KotlinDeserializersKt;
import com.fasterxml.jackson.module.kotlin.NoConversionCreatorBoxDeserializer;
import com.fasterxml.jackson.module.kotlin.ReflectionCache;
import com.fasterxml.jackson.module.kotlin.RegexDeserializer;
import com.fasterxml.jackson.module.kotlin.SequenceDeserializer;
import com.fasterxml.jackson.module.kotlin.UByteDeserializer;
import com.fasterxml.jackson.module.kotlin.UIntDeserializer;
import com.fasterxml.jackson.module.kotlin.ULongDeserializer;
import com.fasterxml.jackson.module.kotlin.UShortDeserializer;
import com.fasterxml.jackson.module.kotlin.ValueClassBoxConverter;
import com.fasterxml.jackson.module.kotlin.WrapsAnyValueClassBoxDeserializer;
import com.fasterxml.jackson.module.kotlin.WrapsNullableValueClassDeserializer;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinDeserializers;", "Lcom/fasterxml/jackson/databind/deser/Deserializers$Base;", "cache", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "useJavaDurationConversion", "", "<init>", "(Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;Z)V", "findBeanDeserializer", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "config", "Lcom/fasterxml/jackson/databind/DeserializationConfig;", "beanDesc", "Lcom/fasterxml/jackson/databind/BeanDescription;", "jackson-module-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinDeserializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDeserializers.kt\ncom/fasterxml/jackson/module/kotlin/KotlinDeserializers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1#2:312\n*E\n"})
public final class KotlinDeserializers
extends Deserializers.Base {
    @NotNull
    private final ReflectionCache cache;
    private final boolean useJavaDurationConversion;

    public KotlinDeserializers(@NotNull ReflectionCache cache, boolean useJavaDurationConversion) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.cache = cache;
        this.useJavaDurationConversion = useJavaDurationConversion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public JsonDeserializer<?> findBeanDeserializer(@NotNull JavaType type, @Nullable DeserializationConfig config, @Nullable BeanDescription beanDesc) {
        JsonDeserializer jsonDeserializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Class rawClass = type.getRawClass();
        if (type.isInterface() && Intrinsics.areEqual((Object)rawClass, Sequence.class)) {
            jsonDeserializer = (JsonDeserializer)SequenceDeserializer.INSTANCE;
            return jsonDeserializer;
        } else if (Intrinsics.areEqual((Object)rawClass, Regex.class)) {
            jsonDeserializer = (JsonDeserializer)RegexDeserializer.INSTANCE;
            return jsonDeserializer;
        } else if (Intrinsics.areEqual((Object)rawClass, UByte.class)) {
            jsonDeserializer = (JsonDeserializer)UByteDeserializer.INSTANCE;
            return jsonDeserializer;
        } else if (Intrinsics.areEqual((Object)rawClass, UShort.class)) {
            jsonDeserializer = (JsonDeserializer)UShortDeserializer.INSTANCE;
            return jsonDeserializer;
        } else if (Intrinsics.areEqual((Object)rawClass, UInt.class)) {
            jsonDeserializer = (JsonDeserializer)UIntDeserializer.INSTANCE;
            return jsonDeserializer;
        } else if (Intrinsics.areEqual((Object)rawClass, ULong.class)) {
            jsonDeserializer = (JsonDeserializer)ULongDeserializer.INSTANCE;
            return jsonDeserializer;
        } else if (Intrinsics.areEqual((Object)rawClass, Duration.class)) {
            JavaToKotlinDurationConverter javaToKotlinDurationConverter;
            JavaToKotlinDurationConverter it = javaToKotlinDurationConverter = JavaToKotlinDurationConverter.INSTANCE;
            boolean bl = false;
            JavaToKotlinDurationConverter javaToKotlinDurationConverter2 = this.useJavaDurationConversion ? javaToKotlinDurationConverter : null;
            jsonDeserializer = (JsonDeserializer)(javaToKotlinDurationConverter2 != null ? javaToKotlinDurationConverter2.getDelegatingDeserializer() : null);
            return jsonDeserializer;
        } else {
            WrapsNullableValueClassDeserializer wrapsNullableValueClassDeserializer;
            Intrinsics.checkNotNull((Object)rawClass);
            if (!InternalCommonsKt.isUnboxableValueClass(rawClass)) return null;
            Method method = KotlinDeserializersKt.access$findValueCreator(type, rawClass);
            if (method != null) {
                ValueClassBoxConverter<?, ?> converter;
                Method it = method;
                boolean bl = false;
                Class<?> unboxedClass = it.getReturnType();
                Intrinsics.checkNotNull(unboxedClass);
                ValueClassBoxConverter<?, ?> valueClassBoxConverter = converter = this.cache.getValueClassBoxConverter(unboxedClass, rawClass);
                if (valueClassBoxConverter instanceof ValueClassBoxConverter.Specified) {
                    Class<?> inputType = it.getParameterTypes()[0];
                    if (Intrinsics.areEqual(inputType, unboxedClass)) {
                        wrapsNullableValueClassDeserializer = NoConversionCreatorBoxDeserializer.Companion.create(it, (ValueClassBoxConverter.Specified)converter);
                    } else {
                        Intrinsics.checkNotNull(inputType);
                        wrapsNullableValueClassDeserializer = new HasConversionCreatorWrapsSpecifiedBoxDeserializer(it, inputType, converter);
                    }
                } else {
                    if (!(valueClassBoxConverter instanceof GenericValueClassBoxConverter)) throw new NoWhenBranchMatchedException();
                    Class<?> clazz = it.getParameterTypes()[0];
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"get(...)");
                    wrapsNullableValueClassDeserializer = new WrapsAnyValueClassBoxDeserializer(it, clazz, (GenericValueClassBoxConverter)converter);
                }
            } else {
                wrapsNullableValueClassDeserializer = null;
            }
            jsonDeserializer = (JsonDeserializer)wrapsNullableValueClassDeserializer;
        }
        return jsonDeserializer;
    }
}

