/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.customProperties;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.annotation.JsonHyperSchema;
import com.fasterxml.jackson.module.jsonSchema.annotation.Link;
import com.fasterxml.jackson.module.jsonSchema.factories.ArrayVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.LinkDescriptionObject;
import com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;

public class HyperSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    private boolean ignoreDefaults = true;

    public HyperSchemaFactoryWrapper() {
        super(new HyperSchemaFactoryWrapperFactory());
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        ObjectVisitor visitor = (ObjectVisitor)super.expectObjectFormat(convertedType);
        this.addHyperlinks(visitor.getSchema(), convertedType);
        return visitor;
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArrayVisitor visitor = (ArrayVisitor)super.expectArrayFormat(convertedType);
        this.addHyperlinks(visitor.getSchema(), convertedType);
        return visitor;
    }

    public void setIgnoreDefaults(boolean ignoreDefaults) {
        this.ignoreDefaults = ignoreDefaults;
    }

    private void addHyperlinks(JsonSchema schema, JavaType type) {
        if (!schema.isSimpleTypeSchema()) {
            throw new RuntimeException("given non simple type schema: " + schema.getType());
        }
        Class rawClass = type.getRawClass();
        if (rawClass.isAnnotationPresent(JsonHyperSchema.class)) {
            JsonHyperSchema hyperSchema = rawClass.getAnnotation(JsonHyperSchema.class);
            String pathStart = hyperSchema.pathStart();
            Link[] links = hyperSchema.links();
            LinkDescriptionObject[] linkDescriptionObjects = new LinkDescriptionObject[links.length];
            for (int i = 0; i < links.length; ++i) {
                Link link = links[i];
                linkDescriptionObjects[i] = new LinkDescriptionObject().setHref(pathStart + link.href()).setRel(link.rel()).setMethod((String)(this.ignoreDefaults && "GET".equals(link.method()) ? null : link.method())).setEnctype((String)(this.ignoreDefaults && "application/json".equals(link.enctype()) ? null : link.enctype())).setTargetSchema(this.fetchSchema(link.targetSchema())).setSchema(this.fetchSchema(link.schema())).setMediaType((String)(this.ignoreDefaults && "application/json".equals(link.mediaType()) ? null : link.mediaType())).setTitle(link.title());
            }
            SimpleTypeSchema simpleTypeSchema = schema.asSimpleTypeSchema();
            simpleTypeSchema.setLinks(linkDescriptionObjects);
            if (pathStart != null && pathStart.length() != 0) {
                simpleTypeSchema.setPathStart(pathStart);
            }
        }
    }

    private JsonSchema fetchSchema(Class<?> targetSchema) {
        if (this.provider instanceof DefaultSerializerProvider && targetSchema != Void.TYPE) {
            JavaType targetType = this.provider.constructType(targetSchema);
            try {
                String seenSchemaUri;
                if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(targetType)) != null) {
                    return new ReferenceSchema(seenSchemaUri);
                }
                HyperSchemaFactoryWrapper targetVisitor = new HyperSchemaFactoryWrapper();
                targetVisitor.setVisitorContext(this.visitorContext);
                ((DefaultSerializerProvider)this.provider).acceptJsonFormatVisitor(targetType, (JsonFormatVisitorWrapper)targetVisitor);
                return targetVisitor.finalSchema();
            }
            catch (JsonMappingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static class HyperSchemaFactoryWrapperFactory
    extends WrapperFactory {
        private HyperSchemaFactoryWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p) {
            HyperSchemaFactoryWrapper wrapper = new HyperSchemaFactoryWrapper();
            wrapper.setProvider(p);
            return wrapper;
        }
    }
}

