/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;
import java.util.Map;

public class ArraySchema
extends ContainerTypeSchema {
    @JsonProperty
    private AdditionalItems additionalItems;
    @JsonProperty
    private Items items;
    @JsonProperty
    private Integer maxItems;
    @JsonProperty
    private Integer minItems;
    @JsonProperty
    private Boolean uniqueItems = null;

    @Override
    public ArraySchema asArraySchema() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)object;
            return this.getAdditionalItems() == null ? arraySchema.getAdditionalItems() == null : (this.getAdditionalItems().equals(arraySchema.getAdditionalItems()) && this.getItems() == null ? arraySchema.getItems() == null : (this.getItems().equals(arraySchema.getItems()) && this.getMaxItems() == null ? arraySchema.getMaxItems() == null : (this.getMaxItems().equals(arraySchema.getMaxItems()) && this.getMinItems() == null ? arraySchema.getMinItems() == null : (this.getMinItems().equals(arraySchema.getMinItems()) && this.getUniqueItems() == null ? arraySchema.getUniqueItems() == null : this.getUniqueItems().equals(arraySchema.getUniqueItems()) && super.equals(object)))));
        }
        return false;
    }

    public AdditionalItems getAdditionalItems() {
        return this.additionalItems;
    }

    public Items getItems() {
        return this.items;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    @Override
    public JsonFormatTypes getType() {
        return JsonFormatTypes.ARRAY;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public boolean isArraySchema() {
        return true;
    }

    public void setAdditionalItems(AdditionalItems additionalItems) {
        this.additionalItems = additionalItems;
    }

    public void setItems(Items items) {
        this.items = items;
    }

    public void setItemsSchema(JsonSchema jsonSchema) {
        this.items = new SingleItems(jsonSchema);
    }

    public void setMaxItems(Integer n) {
        this.maxItems = n;
    }

    public void setMinItems(Integer n) {
        this.minItems = n;
    }

    public void setUniqueItems(Boolean bl) {
        this.uniqueItems = bl;
    }

    public static class SingleItems
    extends Items {
        @JsonIgnore
        private JsonSchema jsonSchema;

        public SingleItems(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        public boolean equals(Object object) {
            return object instanceof SingleItems && this.getSchema() == null ? ((SingleItems)object).getSchema() == null : this.getSchema().equals(((SingleItems)object).getSchema());
        }

        @JsonValue
        public JsonSchema getSchema() {
            return this.jsonSchema;
        }

        public void setSchema(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        @Override
        public boolean isSingleItems() {
            return true;
        }

        @Override
        public SingleItems asSingleItems() {
            return this;
        }
    }

    public static class SchemaAdditionalItems
    extends AdditionalItems {
        @JsonIgnore
        private JsonSchema jsonSchema;

        public SchemaAdditionalItems(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        public boolean equals(Object object) {
            return object instanceof SchemaAdditionalItems && this.getJsonSchema() == null ? ((SchemaAdditionalItems)object).getJsonSchema() == null : this.getJsonSchema().equals(((SchemaAdditionalItems)object).getJsonSchema());
        }

        @JsonValue
        public JsonSchema getJsonSchema() {
            return this.jsonSchema;
        }
    }

    public static class NoAdditionalItems
    extends AdditionalItems {
        public boolean equals(Object object) {
            return object instanceof NoAdditionalItems;
        }

        @JsonValue
        public Boolean value() {
            return false;
        }
    }

    public static abstract class Items {
        @JsonIgnore
        public boolean isSingleItems() {
            return false;
        }

        @JsonIgnore
        public boolean isArrayItems() {
            return false;
        }

        public SingleItems asSingleItems() {
            return null;
        }

        public ArrayItems asArrayItems() {
            return null;
        }

        @JsonCreator
        public static Items jsonCreator(Map<String, Object> map) {
            Object object = map.get("type");
            if (object == null || !(object instanceof String)) {
                return null;
            }
            String string = (String)object;
            JsonSchema jsonSchema = JsonSchema.minimalForFormat(JsonFormatTypes.forValue((String)string));
            return new SingleItems(jsonSchema);
        }
    }

    public static class ArrayItems
    extends Items {
        @JsonProperty
        private JsonSchema[] jsonSchemas;

        @Override
        public ArrayItems asArrayItems() {
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Items) {
                ArrayItems arrayItems = (ArrayItems)object;
                return this.getJsonSchemas() == null ? arrayItems.getJsonSchemas() == null : this.getJsonSchemas().equals(arrayItems.getJsonSchemas());
            }
            return false;
        }

        public JsonSchema[] getJsonSchemas() {
            return this.jsonSchemas;
        }

        @Override
        public boolean isArrayItems() {
            return true;
        }
    }

    public static abstract class AdditionalItems {
        @JsonCreator
        public static Items jsonCreator(Map<String, Object> map) {
            return null;
        }
    }
}

