/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;

public class ObjectVisitor
extends JsonObjectFormatVisitor.Base
implements JsonSchemaProducer {
    protected final ObjectSchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory = new WrapperFactory();

    public ObjectVisitor(SerializerProvider serializerProvider, ObjectSchema objectSchema) {
        this.provider = serializerProvider;
        this.schema = objectSchema;
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider serializerProvider) {
        this.provider = serializerProvider;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    public void optionalProperty(BeanProperty beanProperty) throws JsonMappingException {
        this.schema.putOptionalProperty(beanProperty, this.propertySchema(beanProperty));
    }

    public void optionalProperty(String string, JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
        this.schema.putOptionalProperty(string, this.propertySchema(jsonFormatVisitable, javaType));
    }

    public void property(BeanProperty beanProperty) throws JsonMappingException {
        this.schema.putProperty(beanProperty, this.propertySchema(beanProperty));
    }

    public void property(String string, JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
        this.schema.putProperty(string, this.propertySchema(jsonFormatVisitable, javaType));
    }

    protected JsonSchema propertySchema(BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty == null) {
            throw new IllegalArgumentException("Null property");
        }
        SchemaFactoryWrapper schemaFactoryWrapper = this.wrapperFactory.getWrapper(this.getProvider());
        JsonSerializer<Object> jsonSerializer = this.getSer(beanProperty);
        if (jsonSerializer != null) {
            JavaType javaType = beanProperty.getType();
            if (javaType == null) {
                throw new IllegalStateException("Missing type for property '" + beanProperty.getName() + "'");
            }
            jsonSerializer.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)schemaFactoryWrapper, javaType);
        }
        return schemaFactoryWrapper.finalSchema();
    }

    protected JsonSchema propertySchema(JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
        SchemaFactoryWrapper schemaFactoryWrapper = this.wrapperFactory.getWrapper(this.getProvider());
        jsonFormatVisitable.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)schemaFactoryWrapper, javaType);
        return schemaFactoryWrapper.finalSchema();
    }

    protected JsonSerializer<Object> getSer(BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer jsonSerializer = null;
        if (beanProperty instanceof BeanPropertyWriter) {
            jsonSerializer = ((BeanPropertyWriter)beanProperty).getSerializer();
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.getProvider().findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return jsonSerializer;
    }
}

