/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;

public class MapVisitor
extends JsonMapFormatVisitor.Base
implements JsonSchemaProducer {
    protected final ObjectSchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory = new WrapperFactory();

    public MapVisitor(SerializerProvider serializerProvider, ObjectSchema objectSchema) {
        this.provider = serializerProvider;
        this.schema = objectSchema;
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider serializerProvider) {
        this.provider = serializerProvider;
    }

    public void keyFormat(JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
    }

    public void valueFormat(JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
        JsonSchema jsonSchema = this.propertySchema(jsonFormatVisitable, javaType);
        ObjectSchema.SchemaAdditionalProperties schemaAdditionalProperties = new ObjectSchema.SchemaAdditionalProperties(jsonSchema.asSimpleTypeSchema());
        this.schema.setAdditionalProperties(schemaAdditionalProperties);
    }

    protected JsonSchema propertySchema(JsonFormatVisitable jsonFormatVisitable, JavaType javaType) throws JsonMappingException {
        SchemaFactoryWrapper schemaFactoryWrapper = this.wrapperFactory.getWrapper(this.getProvider());
        jsonFormatVisitable.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)schemaFactoryWrapper, javaType);
        return schemaFactoryWrapper.finalSchema();
    }
}

