/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NullSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.module.jsonSchema.types.UnionTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeIdResolver(value=JsonSchemaIdResolver.class)
public abstract class JsonSchema {
    @JsonProperty
    private String $ref;
    @JsonProperty
    private String $schema;
    @JsonProperty
    private JsonSchema[] disallow;
    @JsonIgnore
    private JsonSchema[] extendsextends;
    @JsonProperty
    private String id;
    @JsonProperty
    private Boolean required = null;

    public AnySchema asAnySchema() {
        return null;
    }

    public ArraySchema asArraySchema() {
        return null;
    }

    public BooleanSchema asBooleanSchema() {
        return null;
    }

    public ContainerTypeSchema asContainerSchema() {
        return null;
    }

    public IntegerSchema asIntegerSchema() {
        return null;
    }

    public NullSchema asNullSchema() {
        return null;
    }

    public NumberSchema asNumberSchema() {
        return null;
    }

    public ObjectSchema asObjectSchema() {
        return null;
    }

    public SimpleTypeSchema asSimpleTypeSchema() {
        return null;
    }

    public StringSchema asStringSchema() {
        return null;
    }

    public UnionTypeSchema asUnionTypeSchema() {
        return null;
    }

    public ValueTypeSchema asValueSchemaSchema() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonSchema)) {
            return false;
        }
        JsonSchema that = (JsonSchema)obj;
        return that.getType() == this.getType() && this.getRequired() == null ? that.getRequired() == null : (this.getRequired().equals(that.getRequired()) && this.get$ref() == null ? that.get$ref() == null : (this.get$ref().equals(that.get$ref()) && this.get$schema() == null ? that.get$schema() == null : (this.get$schema().equals(that.get$schema()) && this.getDisallow() == null ? that.getDisallow() == null : (this.getDisallow().equals(that.getDisallow()) && this.getExtends() == null ? that.getExtends() == null : this.getExtends().equals(that.getExtends())))));
    }

    public String get$ref() {
        return this.$ref;
    }

    public String get$schema() {
        return this.$schema;
    }

    public JsonSchema[] getDisallow() {
        return this.disallow;
    }

    @JsonGetter(value="extends")
    public JsonSchema[] getExtends() {
        return this.extendsextends;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getRequired() {
        return this.required;
    }

    @JsonIgnore
    public abstract JsonFormatTypes getType();

    @JsonIgnore
    public boolean isAnySchema() {
        return false;
    }

    @JsonIgnore
    public boolean isArraySchema() {
        return false;
    }

    @JsonIgnore
    public boolean isBooleanSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isContainerTypeSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isIntegerSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isNullSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isNumberSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isObjectSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isSimpleTypeSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isStringSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isUnionTypeSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isValueTypeSchema() {
        return false;
    }

    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    public void set$schema(String $schema) {
        this.$schema = $schema;
    }

    public void setDisallow(JsonSchema[] disallow) {
        this.disallow = disallow;
    }

    @JsonSetter(value="extends")
    public void setExtends(JsonSchema[] extendsextends) {
        this.extendsextends = extendsextends;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public static JsonSchema minimalForFormat(JsonFormatTypes format) {
        switch (format) {
            case ARRAY: {
                return new ArraySchema();
            }
            case OBJECT: {
                return new ObjectSchema();
            }
            case BOOLEAN: {
                return new BooleanSchema();
            }
            case INTEGER: {
                return new IntegerSchema();
            }
            case NUMBER: {
                return new NumberSchema();
            }
            case STRING: {
                return new StringSchema();
            }
            case NULL: {
                return new NullSchema();
            }
        }
        return new AnySchema();
    }

    public static class JsonSchemaIdResolver
    implements TypeIdResolver {
        private static JavaType any = TypeFactory.defaultInstance().constructType(AnySchema.class);
        private static JavaType array = TypeFactory.defaultInstance().constructType(ArraySchema.class);
        private static JavaType booleanboolean = TypeFactory.defaultInstance().constructType(BooleanSchema.class);
        private static JavaType integer = TypeFactory.defaultInstance().constructType(IntegerSchema.class);
        private static JavaType nullnull = TypeFactory.defaultInstance().constructType(NullSchema.class);
        private static JavaType number = TypeFactory.defaultInstance().constructType(NumberSchema.class);
        private static JavaType object = TypeFactory.defaultInstance().constructType(ObjectSchema.class);
        private static JavaType string = TypeFactory.defaultInstance().constructType(StringSchema.class);

        public String idFromValue(Object value) {
            if (value instanceof JsonSchema) {
                return ((JsonSchema)value).getType().value();
            }
            return null;
        }

        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return this.idFromValue(value);
        }

        public JavaType typeFromId(String id) {
            switch (JsonFormatTypes.forValue((String)id)) {
                case ANY: {
                    return any;
                }
                case ARRAY: {
                    return array;
                }
                case BOOLEAN: {
                    return booleanboolean;
                }
                case INTEGER: {
                    return integer;
                }
                case NULL: {
                    return nullnull;
                }
                case NUMBER: {
                    return number;
                }
                case OBJECT: {
                    return object;
                }
                case STRING: {
                    return string;
                }
            }
            return null;
        }

        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.CUSTOM;
        }

        public void init(JavaType baseType) {
        }

        public String idFromBaseType() {
            return null;
        }
    }
}

