/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsonSchema.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonSchema.factories.ArraySchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.BooleanSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.IntegerSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.NullSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.NumberSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.ObjectSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.StringSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.ValueTypeSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.databind.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.JsonSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.NullSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ValueTypeSchema;

public class SchemaFactoryWrapper
implements JsonFormatVisitorWrapper {
    private SchemaFactory delegate;
    protected FactoryProvider factoryProvider;
    protected SerializerProvider provider;
    protected SchemaProvider schemaProvider = new SchemaProvider();

    public SchemaFactoryWrapper() {
        this.factoryProvider = new FactoryProvider();
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        AnySchema anySchema = this.schemaProvider.anySchema();
        this.delegate = this.factoryProvider.schemaFactory(anySchema);
        return this.factoryProvider.anySchemaFactory(this.delegate, anySchema);
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArraySchema arraySchema = this.schemaProvider.arraySchema();
        this.delegate = this.factoryProvider.schemaFactory(arraySchema);
        return this.factoryProvider.arraySchemaFactory(this.delegate, arraySchema);
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        BooleanSchema booleanSchema = this.schemaProvider.booleanSchema();
        this.delegate = this.factoryProvider.schemaFactory(booleanSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.valueTypeSchemaFactory(this.delegate, booleanSchema);
        return this.factoryProvider.booleanSchemaFactory(valueTypeSchemaFactory, booleanSchema);
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType convertedType) {
        IntegerSchema integerSchema = this.schemaProvider.integerSchema();
        this.delegate = this.factoryProvider.schemaFactory(integerSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.valueTypeSchemaFactory(this.delegate, integerSchema);
        return this.factoryProvider.integerSchemaFactory(valueTypeSchemaFactory, integerSchema);
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        NullSchema nullSchema = this.schemaProvider.nullSchema();
        this.delegate = this.factoryProvider.schemaFactory(nullSchema);
        return this.factoryProvider.nullSchemaFactory(this.delegate, nullSchema);
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        NumberSchema numberSchema = this.schemaProvider.numberSchema();
        this.delegate = this.factoryProvider.schemaFactory(numberSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.valueTypeSchemaFactory(this.delegate, numberSchema);
        return this.factoryProvider.numberSchemaFactory(valueTypeSchemaFactory, numberSchema);
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        ObjectSchema objectSchema = this.schemaProvider.objectSchema();
        this.delegate = this.factoryProvider.schemaFactory(objectSchema);
        return this.factoryProvider.objectSchemaFactory(this.delegate, objectSchema);
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType convertedType) {
        StringSchema stringSchema = this.schemaProvider.StringSchema();
        this.delegate = this.factoryProvider.schemaFactory(stringSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.valueTypeSchemaFactory(this.delegate, stringSchema);
        return this.factoryProvider.stringSchemaFactory(valueTypeSchemaFactory, stringSchema);
    }

    public JsonSchema finalSchema() {
        assert (this.delegate != null) : "SchemaFactory must envoke a delegate method before it can return a JsonSchema.";
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getSchema();
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider provider) {
        this.provider = provider;
    }

    protected class SchemaProvider {
        protected SchemaProvider() {
        }

        public AnySchema anySchema() {
            return new AnySchema();
        }

        public ArraySchema arraySchema() {
            return new ArraySchema();
        }

        public BooleanSchema booleanSchema() {
            return new BooleanSchema();
        }

        public IntegerSchema integerSchema() {
            return new IntegerSchema();
        }

        public NullSchema nullSchema() {
            return new NullSchema();
        }

        public NumberSchema numberSchema() {
            return new NumberSchema();
        }

        public ObjectSchema objectSchema() {
            return new ObjectSchema();
        }

        public StringSchema StringSchema() {
            return new StringSchema();
        }
    }

    public class SchemaFactoryWrapperProvider {
        public SchemaFactoryWrapper schemaFactoryWrapper() {
            return this.schemaFactoryWrapper(SchemaFactoryWrapper.this.getProvider());
        }

        public SchemaFactoryWrapper schemaFactoryWrapper(SerializerProvider provider) {
            SchemaFactoryWrapper wrapper = new SchemaFactoryWrapper();
            wrapper.setProvider(provider);
            return wrapper;
        }
    }

    protected class FactoryProvider {
        protected SchemaFactoryWrapperProvider factoryWrapperProvider;

        public SchemaFactoryWrapperProvider getFactoryWrapperProvider() {
            return this.factoryWrapperProvider;
        }

        public void setFactoryWrapperProvider(SchemaFactoryWrapperProvider factoryWrapperProvider) {
            this.factoryWrapperProvider = factoryWrapperProvider;
        }

        public FactoryProvider() {
            this.factoryWrapperProvider = new SchemaFactoryWrapperProvider();
        }

        public JsonAnyFormatVisitor anySchemaFactory(SchemaFactory delegate, AnySchema anySchema) {
            return null;
        }

        public JsonArrayFormatVisitor arraySchemaFactory(SchemaFactory parent, ArraySchema arraySchema) {
            ArraySchemaFactory arraySchemaFactory = new ArraySchemaFactory(parent, arraySchema);
            arraySchemaFactory.setFactoryWrapperProvider(this.factoryWrapperProvider);
            return arraySchemaFactory;
        }

        public JsonBooleanFormatVisitor booleanSchemaFactory(ValueTypeSchemaFactory parent, BooleanSchema booleanSchema) {
            return new BooleanSchemaFactory(parent, booleanSchema);
        }

        public JsonIntegerFormatVisitor integerSchemaFactory(ValueTypeSchemaFactory parent, IntegerSchema integerSchema) {
            return new IntegerSchemaFactory(parent, integerSchema);
        }

        public JsonNullFormatVisitor nullSchemaFactory(SchemaFactory parent, NullSchema nullSchema) {
            return new NullSchemaFactory(parent, nullSchema);
        }

        public JsonNumberFormatVisitor numberSchemaFactory(ValueTypeSchemaFactory parent, NumberSchema numberSchema) {
            return new NumberSchemaFactory(parent, numberSchema);
        }

        public JsonObjectFormatVisitor objectSchemaFactory(SchemaFactory parent, ObjectSchema objectSchema) {
            ObjectSchemaFactory objectSchemaFactory = new ObjectSchemaFactory(parent, objectSchema);
            objectSchemaFactory.setFactoryWrapperProvider(this.factoryWrapperProvider);
            return objectSchemaFactory;
        }

        public SchemaFactory schemaFactory(JsonSchema schema) {
            return new SchemaFactory(SchemaFactoryWrapper.this.provider, schema);
        }

        public JsonStringFormatVisitor stringSchemaFactory(ValueTypeSchemaFactory parent, StringSchema stringSchema) {
            return new StringSchemaFactory(parent, stringSchema);
        }

        public ValueTypeSchemaFactory valueTypeSchemaFactory(SchemaFactory parent, ValueTypeSchema valueTypeSchema) {
            return new ValueTypeSchemaFactory(parent, valueTypeSchema);
        }
    }
}

