/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsonSchema.factories;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaProducer;
import com.fasterxml.jackson.databind.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.databind.jsonSchema.types.JsonSchema;

public class ArraySchemaFactory
implements JsonArrayFormatVisitor,
SchemaProducer {
    protected BeanProperty _property;
    protected SchemaFactoryWrapper.SchemaFactoryWrapperProvider factoryWrapperProvider;
    protected SchemaFactory parent;
    protected ArraySchema schema;

    public ArraySchemaFactory(SchemaFactory schemaFactory, ArraySchema schema) {
        this(schemaFactory, null, schema);
    }

    public ArraySchemaFactory(SchemaFactory parent, BeanProperty property, ArraySchema schema) {
        this.parent = parent;
        this.schema = schema;
    }

    public BeanProperty get_property() {
        return this._property;
    }

    public SchemaFactoryWrapper.SchemaFactoryWrapperProvider getFactoryWrapperProvider() {
        return this.factoryWrapperProvider;
    }

    public SchemaFactory getParent() {
        return this.parent;
    }

    public SerializerProvider getProvider() {
        return this.parent.getProvider();
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    public void itemsFormat(JavaType contentType) {
        if (contentType.getRawClass() != Object.class) {
            try {
                JsonSerializer ser = this.getProvider().findValueSerializer(contentType, this._property);
                if (ser instanceof JsonFormatVisitable) {
                    SchemaFactoryWrapper visitor = this.factoryWrapperProvider.schemaFactoryWrapper();
                    visitor.setProvider(this.parent.getProvider());
                    ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, contentType);
                    this.schema.setItemsSchema(visitor.finalSchema());
                }
            }
            catch (JsonMappingException jsonMappingException) {
                // empty catch block
            }
        }
    }

    public void itemsFormat(JsonFormatTypes format) {
        this.schema.setItemsSchema(JsonSchema.minimalForFormat(format));
    }

    public void set_property(BeanProperty _property) {
        this._property = _property;
    }

    public void setFactoryWrapperProvider(SchemaFactoryWrapper.SchemaFactoryWrapperProvider factoryWrapperProvider) {
        this.factoryWrapperProvider = factoryWrapperProvider;
    }

    public void setParent(SchemaFactory parent) {
        this.parent = parent;
    }

    public void setProvider(SerializerProvider provider) {
        this.parent.setProvider(provider);
    }

    public void setSchema(ArraySchema schema) {
        this.schema = schema;
    }
}

