/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsonSchema.factories;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaProducer;
import com.fasterxml.jackson.databind.jsonSchema.types.JsonSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSchemaFactory
implements JsonObjectFormatVisitor,
SchemaProducer {
    protected SchemaFactoryWrapper.SchemaFactoryWrapperProvider factoryWrapperProvider;
    protected SchemaFactory parent;
    protected ObjectSchema schema;

    public ObjectSchemaFactory(SchemaFactory parent, ObjectSchema schema) {
        this.parent = parent;
        this.schema = schema;
    }

    public SchemaFactoryWrapper.SchemaFactoryWrapperProvider getFactoryWrapperProvider() {
        return this.factoryWrapperProvider;
    }

    public SchemaFactory getParent() {
        return this.parent;
    }

    public SerializerProvider getProvider() {
        return this.parent.getProvider();
    }

    @Override
    public ObjectSchema getSchema() {
        return this.schema;
    }

    private JsonSerializer<Object> getSer(BeanProperty writer) throws JsonMappingException {
        JsonSerializer ser = null;
        if (writer instanceof BeanPropertyWriter) {
            ser = ((BeanPropertyWriter)writer).getSerializer();
        }
        if (ser == null) {
            ser = this.getProvider().findValueSerializer(writer.getType(), writer);
        }
        return ser;
    }

    public void optionalProperty(BeanProperty writer) {
        try {
            this.schema.putOptionalProperty(writer.getName(), this.propertySchema(writer));
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void optionalProperty(String name) {
        this.schema.putOptionalProperty(name, JsonSchema.minimalForFormat(JsonFormatTypes.ANY));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) {
        try {
            this.schema.putOptionalProperty(name, this.propertySchema(handler, propertyTypeHint));
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void property(BeanProperty writer) {
        try {
            this.schema.putProperty(writer.getName(), this.propertySchema(writer));
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void property(String name) {
        this.schema.putProperty(name, JsonSchema.minimalForFormat(JsonFormatTypes.ANY));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType propertyTypeHint) {
        try {
            this.schema.putProperty(name, this.propertySchema(handler, propertyTypeHint));
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected JsonSchema propertySchema(BeanProperty writer) throws JsonMappingException {
        if (writer == null) {
            throw new IllegalArgumentException("Null writer");
        }
        SchemaFactoryWrapper visitor = this.factoryWrapperProvider.SchemaFactoryWrapper();
        visitor.setProvider(this.parent.getProvider());
        JsonSerializer<Object> ser = this.getSer(writer);
        if (ser != null) {
            JavaType type = writer.getType();
            if (type == null) {
                throw new IllegalStateException("Missing type for property '" + writer.getName() + "'");
            }
            ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, type);
        }
        return visitor.finalSchema();
    }

    protected JsonSchema propertySchema(JsonFormatVisitable handler, JavaType propertyTypeHint) throws JsonMappingException {
        SchemaFactoryWrapper visitor = this.factoryWrapperProvider.SchemaFactoryWrapper();
        visitor.setProvider(this.parent.getProvider());
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, propertyTypeHint);
        return visitor.finalSchema();
    }

    public void setFactoryWrapperProvider(SchemaFactoryWrapper.SchemaFactoryWrapperProvider factoryWrapperProvider) {
        this.factoryWrapperProvider = factoryWrapperProvider;
    }

    public void setParent(SchemaFactory parent) {
        this.parent = parent;
    }

    public void setProvider(SerializerProvider provider) {
        this.parent.setProvider(provider);
    }

    public void setSchema(ObjectSchema schema) {
        this.schema = schema;
    }
}

