/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.activation.DataHandler;

public class DataHandlerJsonSerializer
extends StdSerializer<DataHandler> {
    public DataHandlerJsonSerializer() {
        super(DataHandler.class);
    }

    public void serialize(DataHandler dataHandler, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        InputStream inputStream = dataHandler.getInputStream();
        int n = inputStream.read(byArray);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        jsonGenerator.writeBinary(byteArrayOutputStream.toByteArray());
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor;
        if (jsonFormatVisitorWrapper != null && (jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType)) != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
        }
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("array", true);
        ObjectNode objectNode2 = this.createSchemaNode("string");
        objectNode.put("items", (JsonNode)objectNode2);
        return objectNode;
    }
}

