/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

public final class SettableStringMethodProperty
extends OptimizedSettableBeanProperty<SettableStringMethodProperty> {
    private static final long serialVersionUID = 1L;

    public SettableStringMethodProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringMethodProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableStringMethodProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        String text = p.getValueAsString();
        if (text == null) {
            text = this._deserializeString(p, ctxt);
        }
        try {
            this._propertyMutator.stringSetter(bean, this._optimizedIndex, text);
        }
        catch (Throwable e) {
            this._reportProblem(bean, text, e);
        }
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        String text = (String)value;
        try {
            this._propertyMutator.stringSetter(bean, this._optimizedIndex, text);
        }
        catch (Throwable e) {
            this._reportProblem(bean, text, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        String text = p.getValueAsString();
        if (text == null) {
            text = this._deserializeString(p, ctxt);
        }
        return this.setAndReturn(instance, text);
    }
}

