/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongFieldPropertyWriter
extends OptimizedBeanPropertyWriter<LongFieldPropertyWriter> {
    private final long _suppressableLong;
    private final boolean _suppressableLongSet;

    public LongFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (this._suppressableValue != null && this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableLongSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableLongSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new LongFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public LongFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new LongFieldPropertyWriter(this, acc, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public final void unsafeSerializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        long value = this._propertyAccessor.longField(bean, this._propertyIndex);
        if (!this._suppressableLongSet || this._suppressableLong != value) {
            jgen.writeFieldName((SerializableString)this._name);
            jgen.writeNumber(value);
        }
    }
}

