/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.PropertyAccessorCollector;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;

public class SerializerModifier
extends BeanSerializerModifier {
    protected final MyClassLoader _classLoader;

    public SerializerModifier(ClassLoader classLoader) {
        this._classLoader = classLoader == null ? null : new MyClassLoader(classLoader, false);
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        Class clazz = beanDescription.getBeanClass();
        if (!MyClassLoader.canAddClassInPackageOf(clazz)) {
            return list;
        }
        if (this._classLoader != null && Modifier.isPrivate(clazz.getModifiers())) {
            return list;
        }
        PropertyAccessorCollector propertyAccessorCollector = this.findProperties(clazz, serializationConfig, list);
        if (propertyAccessorCollector.isEmpty()) {
            return list;
        }
        BeanPropertyAccessor beanPropertyAccessor = propertyAccessorCollector.findAccessor(this._classLoader);
        ListIterator<BeanPropertyWriter> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            BeanPropertyWriter beanPropertyWriter = listIterator.next();
            if (!(beanPropertyWriter instanceof OptimizedBeanPropertyWriter)) continue;
            listIterator.set((BeanPropertyWriter)((OptimizedBeanPropertyWriter)beanPropertyWriter).withAccessor(beanPropertyAccessor));
        }
        return list;
    }

    protected PropertyAccessorCollector findProperties(Class<?> clazz, SerializationConfig serializationConfig, List<BeanPropertyWriter> list) {
        PropertyAccessorCollector propertyAccessorCollector = new PropertyAccessorCollector(clazz);
        ListIterator<BeanPropertyWriter> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            BeanPropertyWriter beanPropertyWriter = listIterator.next();
            Class clazz2 = beanPropertyWriter.getPropertyType();
            AnnotatedMember annotatedMember = beanPropertyWriter.getMember();
            if (Modifier.isPrivate(annotatedMember.getMember().getModifiers()) || beanPropertyWriter.hasSerializer() && !this.isDefaultSerializer(serializationConfig, beanPropertyWriter.getSerializer()) || beanPropertyWriter instanceof UnwrappingBeanPropertyWriter) continue;
            boolean bl = annotatedMember instanceof AnnotatedMethod;
            if (clazz2.isPrimitive()) {
                if (clazz2 == Integer.TYPE) {
                    if (bl) {
                        listIterator.set(propertyAccessorCollector.addIntGetter(beanPropertyWriter));
                        continue;
                    }
                    listIterator.set(propertyAccessorCollector.addIntField(beanPropertyWriter));
                    continue;
                }
                if (clazz2 != Long.TYPE) continue;
                if (bl) {
                    listIterator.set(propertyAccessorCollector.addLongGetter(beanPropertyWriter));
                    continue;
                }
                listIterator.set(propertyAccessorCollector.addLongField(beanPropertyWriter));
                continue;
            }
            if (clazz2 == String.class) {
                if (bl) {
                    listIterator.set(propertyAccessorCollector.addStringGetter(beanPropertyWriter));
                    continue;
                }
                listIterator.set(propertyAccessorCollector.addStringField(beanPropertyWriter));
                continue;
            }
            if (bl) {
                listIterator.set(propertyAccessorCollector.addObjectGetter(beanPropertyWriter));
                continue;
            }
            listIterator.set(propertyAccessorCollector.addObjectField(beanPropertyWriter));
        }
        return propertyAccessorCollector;
    }

    protected boolean isDefaultSerializer(SerializationConfig serializationConfig, JsonSerializer<?> jsonSerializer) {
        return ClassUtil.isJacksonStdImpl(jsonSerializer);
    }
}

