/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.CreatorOptimizer;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.PropertyMutatorCollector;
import com.fasterxml.jackson.module.afterburner.deser.SuperSonicDeserializerBuilder;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeserializerModifier
extends BeanDeserializerModifier {
    protected final MyClassLoader _classLoader;
    protected final boolean _useCustomDeserializer;

    public DeserializerModifier(ClassLoader classLoader, boolean bl) {
        this._classLoader = classLoader == null ? null : new MyClassLoader(classLoader, false);
        this._useCustomDeserializer = bl;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig deserializationConfig, BeanDescription beanDescription, BeanDeserializerBuilder beanDeserializerBuilder) {
        Object object;
        Class clazz = beanDescription.getBeanClass();
        if (!MyClassLoader.canAddClassInPackageOf(clazz)) {
            return beanDeserializerBuilder;
        }
        if (this._classLoader != null && Modifier.isPrivate(clazz.getModifiers())) {
            return beanDeserializerBuilder;
        }
        PropertyMutatorCollector propertyMutatorCollector = new PropertyMutatorCollector(clazz);
        List<OptimizedSettableBeanProperty<?>> list = this.findOptimizableProperties(deserializationConfig, propertyMutatorCollector, beanDeserializerBuilder.getProperties());
        if (!list.isEmpty()) {
            object = propertyMutatorCollector.buildMutator(this._classLoader);
            for (OptimizedSettableBeanProperty<?> optimizedSettableBeanProperty : list) {
                beanDeserializerBuilder.addOrReplaceProperty(optimizedSettableBeanProperty.withMutator((BeanPropertyMutator)object), true);
            }
        }
        if ((object = beanDeserializerBuilder.getValueInstantiator()).getClass() == StdValueInstantiator.class && object.canCreateUsingDefault() && (object = new CreatorOptimizer(clazz, this._classLoader, (StdValueInstantiator)object).createOptimized()) != null) {
            beanDeserializerBuilder.setValueInstantiator(object);
        }
        if (this._useCustomDeserializer && beanDeserializerBuilder.getClass() == BeanDeserializerBuilder.class) {
            return new SuperSonicDeserializerBuilder(beanDeserializerBuilder);
        }
        return beanDeserializerBuilder;
    }

    protected List<OptimizedSettableBeanProperty<?>> findOptimizableProperties(DeserializationConfig deserializationConfig, PropertyMutatorCollector propertyMutatorCollector, Iterator<SettableBeanProperty> iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Class clazz;
            SettableBeanProperty settableBeanProperty = iterator.next();
            AnnotatedMember annotatedMember = settableBeanProperty.getMember();
            if (Modifier.isPrivate(annotatedMember.getMember().getModifiers()) || settableBeanProperty.hasValueDeserializer() && !this.isDefaultDeserializer(deserializationConfig, settableBeanProperty.getValueDeserializer())) continue;
            if (settableBeanProperty instanceof MethodProperty) {
                clazz = ((AnnotatedMethod)annotatedMember).getRawParameterType(0);
                if (clazz.isPrimitive()) {
                    if (clazz == Integer.TYPE) {
                        arrayList.add(propertyMutatorCollector.addIntSetter(settableBeanProperty));
                        continue;
                    }
                    if (clazz != Long.TYPE) continue;
                    arrayList.add(propertyMutatorCollector.addLongSetter(settableBeanProperty));
                    continue;
                }
                if (clazz == String.class) {
                    arrayList.add(propertyMutatorCollector.addStringSetter(settableBeanProperty));
                    continue;
                }
                arrayList.add(propertyMutatorCollector.addObjectSetter(settableBeanProperty));
                continue;
            }
            if (!(settableBeanProperty instanceof FieldProperty)) continue;
            clazz = annotatedMember.getRawType();
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    arrayList.add(propertyMutatorCollector.addIntField(settableBeanProperty));
                    continue;
                }
                if (clazz != Long.TYPE) continue;
                arrayList.add(propertyMutatorCollector.addLongField(settableBeanProperty));
                continue;
            }
            if (clazz == String.class) {
                arrayList.add(propertyMutatorCollector.addStringField(settableBeanProperty));
                continue;
            }
            arrayList.add(propertyMutatorCollector.addObjectField(settableBeanProperty));
        }
        return arrayList;
    }

    protected boolean isDefaultDeserializer(DeserializationConfig deserializationConfig, JsonDeserializer<?> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer);
    }
}

