/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedValueInstantiator;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CreatorOptimizer
extends DynamicPropertyAccessorBase {
    protected final Class<?> _valueClass;
    protected final MyClassLoader _classLoader;
    protected final StdValueInstantiator _originalInstantiator;

    public CreatorOptimizer(Class<?> clazz, MyClassLoader myClassLoader, StdValueInstantiator stdValueInstantiator) {
        this._valueClass = clazz;
        this._classLoader = myClassLoader;
        this._originalInstantiator = stdValueInstantiator;
    }

    public ValueInstantiator createOptimized() {
        if (this._originalInstantiator.canCreateFromObjectWith() || this._originalInstantiator.canCreateUsingDelegate()) {
            return null;
        }
        AnnotatedWithParams annotatedWithParams = this._originalInstantiator.getDefaultCreator();
        if (annotatedWithParams != null) {
            Method method;
            int n;
            AnnotatedElement annotatedElement = annotatedWithParams.getAnnotated();
            if (annotatedElement instanceof Constructor) {
                Constructor constructor = (Constructor)annotatedElement;
                if (!Modifier.isPrivate(constructor.getModifiers())) {
                    return this.createSubclass(constructor, null);
                }
            } else if (annotatedElement instanceof Method && Modifier.isStatic(n = (method = (Method)annotatedElement).getModifiers()) && !Modifier.isPrivate(n)) {
                return this.createSubclass(null, method);
            }
        }
        return null;
    }

    protected ValueInstantiator createSubclass(Constructor<?> constructor, Method method) {
        Object object;
        MyClassLoader myClassLoader = this._classLoader == null ? new MyClassLoader(this._valueClass.getClassLoader(), true) : this._classLoader;
        String string = this._valueClass.getName() + "$Creator4JacksonDeserializer";
        Class<?> clazz = null;
        try {
            clazz = myClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            object = this.generateOptimized(string, constructor, method);
            clazz = myClassLoader.loadAndResolve(string, (byte[])object);
        }
        try {
            object = (ValueInstantiator)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to generate accessor class '" + string + "': " + exception.getMessage(), exception);
        }
        return object;
    }

    protected byte[] generateOptimized(String string, Constructor<?> constructor, Method method) {
        ClassWriter classWriter = new ClassWriter(1);
        String string2 = CreatorOptimizer.internalClassName(OptimizedValueInstantiator.class.getName());
        String string3 = CreatorOptimizer.internalClassName(string);
        classWriter.visit(49, 33, string3, null, string2, null);
        classWriter.visitSource(string + ".java", null);
        String string4 = Type.getDescriptor(OptimizedValueInstantiator.class);
        String string5 = Type.getDescriptor(StdValueInstantiator.class);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, string2, "<init>", "()V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "<init>", "(" + string5 + ")V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, string2, "<init>", "(" + string5 + ")V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "with", "(" + string5 + ")" + string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, string3);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, string3, "<init>", "(" + string5 + ")V");
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "createUsingDefault", "(" + Type.getDescriptor(DeserializationContext.class) + ")Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        if (constructor != null) {
            this.addCreator(methodVisitor, constructor);
        } else {
            this.addCreator(methodVisitor, method);
        }
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    protected void addCreator(MethodVisitor methodVisitor, Constructor<?> constructor) {
        String string = Type.getInternalName(constructor.getDeclaringClass());
        methodVisitor.visitTypeInsn(187, string);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, string, "<init>", "()V");
    }

    protected void addCreator(MethodVisitor methodVisitor, Method method) {
        Class<?> clazz = method.getReturnType();
        methodVisitor.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), "()" + Type.getDescriptor(clazz));
    }
}

