/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringFieldPropertyWriter
extends OptimizedBeanPropertyWriter<StringFieldPropertyWriter> {
    public StringFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringFieldPropertyWriter(this, acc, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        String value = this._propertyAccessor.stringField(bean, this._propertyIndex);
        if (value == null) {
            if (!this._suppressNulls) {
                jgen.writeFieldName((SerializableString)this._name);
                prov.defaultSerializeNull(jgen);
            }
            return;
        }
        if (this._suppressableValue != null && this._suppressableValue.equals(value)) {
            return;
        }
        jgen.writeFieldName((SerializableString)this._name);
        jgen.writeString(value);
    }
}

