/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableIntFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableIntMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableLongFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableLongMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableObjectFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableObjectMethodProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableStringFieldProperty;
import com.fasterxml.jackson.module.afterburner.deser.SettableStringMethodProperty;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMutatorCollector
extends DynamicPropertyAccessorBase {
    private final ArrayList<SettableIntMethodProperty> _intSetters = new ArrayList();
    private final ArrayList<SettableLongMethodProperty> _longSetters = new ArrayList();
    private final ArrayList<SettableStringMethodProperty> _stringSetters = new ArrayList();
    private final ArrayList<SettableObjectMethodProperty> _objectSetters = new ArrayList();
    private final ArrayList<SettableIntFieldProperty> _intFields = new ArrayList();
    private final ArrayList<SettableLongFieldProperty> _longFields = new ArrayList();
    private final ArrayList<SettableStringFieldProperty> _stringFields = new ArrayList();
    private final ArrayList<SettableObjectFieldProperty> _objectFields = new ArrayList();

    public SettableIntMethodProperty addIntSetter(SettableBeanProperty prop) {
        return this._add(this._intSetters, new SettableIntMethodProperty(prop, null, this._intSetters.size()));
    }

    public SettableLongMethodProperty addLongSetter(SettableBeanProperty prop) {
        return this._add(this._longSetters, new SettableLongMethodProperty(prop, null, this._longSetters.size()));
    }

    public SettableStringMethodProperty addStringSetter(SettableBeanProperty prop) {
        return this._add(this._stringSetters, new SettableStringMethodProperty(prop, null, this._stringSetters.size()));
    }

    public SettableObjectMethodProperty addObjectSetter(SettableBeanProperty prop) {
        return this._add(this._objectSetters, new SettableObjectMethodProperty(prop, null, this._objectSetters.size()));
    }

    public SettableIntFieldProperty addIntField(SettableBeanProperty prop) {
        return this._add(this._intFields, new SettableIntFieldProperty(prop, null, this._intFields.size()));
    }

    public SettableLongFieldProperty addLongField(SettableBeanProperty prop) {
        return this._add(this._longFields, new SettableLongFieldProperty(prop, null, this._longFields.size()));
    }

    public SettableStringFieldProperty addStringField(SettableBeanProperty prop) {
        return this._add(this._stringFields, new SettableStringFieldProperty(prop, null, this._stringFields.size()));
    }

    public SettableObjectFieldProperty addObjectField(SettableBeanProperty prop) {
        return this._add(this._objectFields, new SettableObjectFieldProperty(prop, null, this._objectFields.size()));
    }

    public boolean isEmpty() {
        return this._intSetters.isEmpty() && this._longSetters.isEmpty() && this._stringSetters.isEmpty() && this._objectSetters.isEmpty() && this._intFields.isEmpty() && this._longFields.isEmpty() && this._stringFields.isEmpty() && this._objectFields.isEmpty();
    }

    public BeanPropertyMutator buildMutator(Class<?> beanType, MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(beanType.getClassLoader(), true);
        }
        String srcName = beanType.getName() + "$Access4JacksonDeserializer";
        String generatedClass = PropertyMutatorCollector.internalClassName(srcName);
        Class<?> accessorClass = null;
        try {
            accessorClass = classLoader.loadClass(srcName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (accessorClass == null) {
            accessorClass = this.generateMutatorClass(beanType, classLoader, srcName, generatedClass);
        }
        try {
            return (BeanPropertyMutator)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + srcName + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateMutatorClass(Class<?> beanType, MyClassLoader classLoader, String srcName, String generatedClass) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = PropertyMutatorCollector.internalClassName(BeanPropertyMutator.class.getName());
        cw.visit(49, 33, generatedClass, null, superClass, null);
        cw.visitSource(srcName + ".java", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        String beanClass = PropertyMutatorCollector.internalClassName(beanType.getName());
        if (!this._intFields.isEmpty()) {
            PropertyMutatorCollector._addIntFields(cw, this._intFields, beanClass);
        }
        if (!this._longFields.isEmpty()) {
            PropertyMutatorCollector._addLongFields(cw, this._longFields, beanClass);
        }
        if (!this._stringFields.isEmpty()) {
            PropertyMutatorCollector._addStringFields(cw, this._stringFields, beanClass);
        }
        if (!this._objectFields.isEmpty()) {
            PropertyMutatorCollector._addObjectFields(cw, this._objectFields, beanClass);
        }
        if (!this._intSetters.isEmpty()) {
            PropertyMutatorCollector._addIntSetters(cw, this._intSetters, beanClass);
        }
        if (!this._longSetters.isEmpty()) {
            PropertyMutatorCollector._addLongSetters(cw, this._longSetters, beanClass);
        }
        if (!this._stringSetters.isEmpty()) {
            PropertyMutatorCollector._addStringSetters(cw, this._stringSetters, beanClass);
        }
        if (!this._objectSetters.isEmpty()) {
            PropertyMutatorCollector._addObjectSetters(cw, this._objectSetters, beanClass);
        }
        cw.visitEnd();
        byte[] byteCode = cw.toByteArray();
        return classLoader.loadAndResolve(srcName, byteCode);
    }

    private static void _addIntSetters(ClassWriter cw, List<SettableIntMethodProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "intSetter", "(Ljava/lang/Object;II)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 4);
        if (props.size() <= 4) {
            PropertyMutatorCollector._addSettersUsingIf(mv, props, beanClass, 21, 4, false);
        } else {
            PropertyMutatorCollector._addSettersUsingSwitch(mv, props, beanClass, 21, 4, false);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addLongSetters(ClassWriter cw, List<SettableLongMethodProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "longSetter", "(Ljava/lang/Object;IJ)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 5);
        if (props.size() <= 4) {
            PropertyMutatorCollector._addSettersUsingIf(mv, props, beanClass, 22, 5, false);
        } else {
            PropertyMutatorCollector._addSettersUsingSwitch(mv, props, beanClass, 22, 5, false);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addStringSetters(ClassWriter cw, List<SettableStringMethodProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "stringSetter", "(Ljava/lang/Object;ILjava/lang/String;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 4);
        if (props.size() <= 4) {
            PropertyMutatorCollector._addSettersUsingIf(mv, props, beanClass, 25, 4, false);
        } else {
            PropertyMutatorCollector._addSettersUsingSwitch(mv, props, beanClass, 25, 4, false);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addObjectSetters(ClassWriter cw, List<SettableObjectMethodProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "objectSetter", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 4);
        if (props.size() <= 4) {
            PropertyMutatorCollector._addSettersUsingIf(mv, props, beanClass, 25, 4, true);
        } else {
            PropertyMutatorCollector._addSettersUsingSwitch(mv, props, beanClass, 25, 4, true);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addIntFields(ClassWriter cw, List<SettableIntFieldProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "intField", "(Ljava/lang/Object;II)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 4);
        if (props.size() < 4) {
            PropertyMutatorCollector._addFieldsUsingIf(mv, props, beanClass, 21, 4, false);
        } else {
            PropertyMutatorCollector._addFieldsUsingSwitch(mv, props, beanClass, 21, 4, false);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addLongFields(ClassWriter cw, List<SettableLongFieldProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "longField", "(Ljava/lang/Object;IJ)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 5);
        if (props.size() < 4) {
            PropertyMutatorCollector._addFieldsUsingIf(mv, props, beanClass, 22, 5, false);
        } else {
            PropertyMutatorCollector._addFieldsUsingSwitch(mv, props, beanClass, 22, 5, false);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addStringFields(ClassWriter cw, List<SettableStringFieldProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "stringField", "(Ljava/lang/Object;ILjava/lang/String;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 4);
        if (props.size() < 4) {
            PropertyMutatorCollector._addFieldsUsingIf(mv, props, beanClass, 25, 4, false);
        } else {
            PropertyMutatorCollector._addFieldsUsingSwitch(mv, props, beanClass, 25, 4, false);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addObjectFields(ClassWriter cw, List<SettableObjectFieldProperty> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "objectField", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 4);
        if (props.size() < 4) {
            PropertyMutatorCollector._addFieldsUsingIf(mv, props, beanClass, 25, 4, true);
        } else {
            PropertyMutatorCollector._addFieldsUsingSwitch(mv, props, beanClass, 25, 4, true);
        }
        PropertyMutatorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static <T extends OptimizedSettableBeanProperty<T>> void _addSettersUsingIf(MethodVisitor mv, List<T> props, String beanClass, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, beanIndex);
        mv.visitVarInsn(loadValueCode, 3);
        Method method = (Method)((OptimizedSettableBeanProperty)((Object)props.get(0))).getMember().getMember();
        Type type = Type.getType(method.getParameterTypes()[0]);
        if (mustCast) {
            mv.visitTypeInsn(192, type.getInternalName());
        }
        mv.visitMethodInsn(182, beanClass, method.getName(), "(" + type.getDescriptor() + ")V");
        mv.visitInsn(177);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(ALL_INT_CONSTS[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            method = (Method)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember().getMember();
            type = Type.getType(method.getParameterTypes()[0]);
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitMethodInsn(182, beanClass, method.getName(), "(" + type.getDescriptor() + ")V");
            mv.visitInsn(177);
        }
        mv.visitLabel(next);
    }

    private static <T extends OptimizedSettableBeanProperty<T>> void _addSettersUsingSwitch(MethodVisitor mv, List<T> props, String beanClass, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            Method method = (Method)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember().getMember();
            Type type = Type.getType(method.getParameterTypes()[0]);
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitMethodInsn(182, beanClass, method.getName(), "(" + type.getDescriptor() + ")V");
            mv.visitInsn(177);
        }
        mv.visitLabel(defaultLabel);
    }

    private static <T extends OptimizedSettableBeanProperty<T>> void _addFieldsUsingIf(MethodVisitor mv, List<T> props, String beanClass, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, beanIndex);
        mv.visitVarInsn(loadValueCode, 3);
        AnnotatedField field = (AnnotatedField)((OptimizedSettableBeanProperty)((Object)props.get(0))).getMember();
        Type type = Type.getType(field.getRawType());
        if (mustCast) {
            mv.visitTypeInsn(192, type.getInternalName());
        }
        mv.visitFieldInsn(181, beanClass, field.getName(), type.getDescriptor());
        mv.visitInsn(177);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(ALL_INT_CONSTS[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            field = (AnnotatedField)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember();
            type = Type.getType(field.getRawType());
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitFieldInsn(181, beanClass, field.getName(), type.getDescriptor());
            mv.visitInsn(177);
        }
        mv.visitLabel(next);
    }

    private static <T extends OptimizedSettableBeanProperty<T>> void _addFieldsUsingSwitch(MethodVisitor mv, List<T> props, String beanClass, int loadValueCode, int beanIndex, boolean mustCast) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, beanIndex);
            mv.visitVarInsn(loadValueCode, 3);
            AnnotatedField field = (AnnotatedField)((OptimizedSettableBeanProperty)((Object)props.get(i))).getMember();
            Type type = Type.getType(field.getRawType());
            if (mustCast) {
                mv.visitTypeInsn(192, type.getInternalName());
            }
            mv.visitFieldInsn(181, beanClass, field.getName(), type.getDescriptor());
            mv.visitInsn(177);
        }
        mv.visitLabel(defaultLabel);
    }
}

