/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MapBuilder {
    protected final int _features;
    protected final Class<?> _mapType;

    protected MapBuilder(int n, Class<?> clazz) {
        this._features = n;
        this._mapType = clazz;
    }

    public static MapBuilder defaultImpl() {
        return new Default(0, null);
    }

    public abstract MapBuilder newBuilder(int var1);

    public abstract MapBuilder newBuilder(Class<?> var1);

    public MapBuilder newBuilder() {
        return this.newBuilder(this._features);
    }

    public final boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public abstract MapBuilder start();

    public abstract MapBuilder put(Object var1, Object var2);

    public abstract Map<Object, Object> build();

    public Map<Object, Object> emptyMap() {
        return this.start().build();
    }

    public Map<Object, Object> singletonMap(Object object, Object object2) {
        return this.start().put(object, object2).build();
    }

    public static class Default
    extends MapBuilder {
        protected Map<Object, Object> _current;

        protected Default(int n, Class<?> clazz) {
            super(n, clazz);
        }

        @Override
        public MapBuilder newBuilder(int n) {
            return new Default(n, this._mapType);
        }

        @Override
        public MapBuilder newBuilder(Class<?> clazz) {
            return new Default(this._features, clazz);
        }

        @Override
        public MapBuilder start() {
            if (this._current != null) {
                return this.newBuilder().start();
            }
            this._current = this._map(12);
            return this;
        }

        @Override
        public Map<Object, Object> build() {
            Map<Object, Object> map = this._current;
            this._current = null;
            return map;
        }

        @Override
        public MapBuilder put(Object object, Object object2) {
            this._current.put(object, object2);
            return this;
        }

        @Override
        public Map<Object, Object> emptyMap() {
            if (this._mapType == null && this.isEnabled(JSON.Feature.READ_ONLY)) {
                return Collections.emptyMap();
            }
            return this._map(4);
        }

        private final Map<Object, Object> _map(int n) {
            if (this._mapType != null) {
                try {
                    Map map = (Map)this._mapType.newInstance();
                    return map;
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    while (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    throw new IllegalArgumentException("Failed to create an instance of " + this._mapType.getName() + " (" + throwable.getClass().getName() + "): " + throwable.getMessage());
                }
            }
            return this.isEnabled(JSON.Feature.PRESERVE_FIELD_ORDERING) ? new LinkedHashMap(n) : new HashMap(n);
        }
    }
}

