/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.PackageVersion;
import java.io.IOException;
import java.util.Iterator;

public class JSONAsObjectCodec
extends ObjectCodec {
    protected final JSON _json;
    protected final JsonFactory _jsonFactory;
    protected final TreeCodec _treeCodec;

    public JSONAsObjectCodec(JSON jSON) {
        this(jSON, jSON.getStreamingFactory());
    }

    public JSONAsObjectCodec(JSON jSON, JsonFactory jsonFactory) {
        this(jSON, jsonFactory, jSON.getTreeCodec());
    }

    public JSONAsObjectCodec(JSON jSON, JsonFactory jsonFactory, TreeCodec treeCodec) {
        this._json = jSON;
        this._jsonFactory = jsonFactory;
        this._treeCodec = treeCodec;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException, JsonProcessingException {
        Object object = this._json.anyFrom(jsonParser);
        this._checkResultType(clazz, object);
        return (T)object;
    }

    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException, JsonProcessingException {
        throw this._noTypeReference();
    }

    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.readValue(jsonParser, resolvedType.getRawClass());
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, Class<T> clazz) throws IOException, JsonProcessingException {
        throw new JSONObjectException("Simple JSON does not support 'readValues()' methods");
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException, JsonProcessingException {
        throw this._noTypeReference();
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, resolvedType.getRawClass());
    }

    protected JSONObjectException _noTypeReference() {
        return new JSONObjectException("Simple JSON does not support use of TypeReference");
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonProcessingException {
        this._json.write(object, jsonGenerator);
    }

    public TreeNode createObjectNode() {
        return this._checkTreeCodec().createObjectNode();
    }

    public TreeNode createArrayNode() {
        return this._checkTreeCodec().createArrayNode();
    }

    public TreeNode missingNode() {
        return this._checkTreeCodec().missingNode();
    }

    public TreeNode nullNode() {
        return this._checkTreeCodec().nullNode();
    }

    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException, JsonProcessingException {
        return (T)this._checkTreeCodec().readTree(jsonParser);
    }

    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws IOException, JsonProcessingException {
        this._checkTreeCodec().writeTree(jsonGenerator, treeNode);
    }

    public JsonParser treeAsTokens(TreeNode treeNode) {
        return this._checkTreeCodec().treeAsTokens(treeNode);
    }

    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws JsonProcessingException {
        try {
            String string = this._json.asString(treeNode);
            JsonParser jsonParser = this._jsonFactory.createParser(string);
            T t = this.readValue(jsonParser, clazz);
            jsonParser.close();
            return t;
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JSONObjectException.fromUnexpectedIOE(iOException);
        }
    }

    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    @Deprecated
    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    protected TreeCodec _checkTreeCodec() {
        TreeCodec treeCodec = this._treeCodec;
        if (treeCodec == null) {
            throw new IllegalStateException("No TreeCodec has been configured: can not use tree operations");
        }
        return treeCodec;
    }

    protected void _checkResultType(Class<?> clazz, Object object) throws JSONObjectException {
        if (object != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new JSONObjectException("Simple JSON can only bind given JSON as " + object.getClass().getName() + ", not as " + clazz.getName());
        }
    }
}

