/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.BeanProperty;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import com.fasterxml.jackson.jr.private.JsonParser;
import com.fasterxml.jackson.jr.private.JsonToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;

public class BeanDefinition
extends ValueReader {
    protected final Class<?> _type;
    protected final BeanProperty[] _properties;
    protected final Map<String, BeanProperty> _propsByName;
    protected final Constructor<?> _defaultCtor;
    protected final Constructor<?> _stringCtor;
    protected final Constructor<?> _longCtor;

    public BeanDefinition(Class<?> clazz, BeanProperty[] beanPropertyArray) {
        this._type = clazz;
        this._properties = beanPropertyArray;
        this._propsByName = null;
        this._defaultCtor = null;
        this._stringCtor = null;
        this._longCtor = null;
    }

    public BeanDefinition(Class<?> clazz, Map<String, BeanProperty> map, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3) {
        this._type = clazz;
        this._properties = null;
        this._propsByName = map;
        this._defaultCtor = constructor;
        this._stringCtor = constructor2;
        this._longCtor = constructor3;
    }

    public BeanProperty[] properties() {
        return this._properties;
    }

    public Map<String, BeanProperty> propertiesByName() {
        return this._propsByName;
    }

    public BeanProperty findProperty(String string) {
        return this._propsByName.get(string);
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    Object object = this.create();
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanProperty beanProperty = this.findProperty(string);
                        if (beanProperty == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        ValueReader valueReader = beanProperty.getReader();
                        beanProperty.setValueFor(object, valueReader.readNext(jSONReader, jsonParser));
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, "Failed to create an instance of " + this._type.getName() + " due to (" + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._type.getName() + " instance out of " + this._tokenDesc(jsonParser));
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    Object object = this.create();
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanProperty beanProperty = this.findProperty(string);
                        if (beanProperty == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        ValueReader valueReader = beanProperty.getReader();
                        beanProperty.setValueFor(object, valueReader.readNext(jSONReader, jsonParser));
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, "Failed to create an instance of " + this._type.getName() + " due to (" + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._type.getName() + " instance out of " + this._tokenDesc(jsonParser));
    }

    protected Object create() throws Exception {
        if (this._defaultCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have default constructor to use");
        }
        return this._defaultCtor.newInstance(new Object[0]);
    }

    protected Object create(String string) throws Exception {
        if (this._stringCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have single-String constructor to use");
        }
        return this._stringCtor.newInstance(string);
    }

    protected Object create(long l) throws Exception {
        if (this._longCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have single-long constructor to use");
        }
        return this._longCtor.newInstance(l);
    }

    protected void handleUnknown(JSONReader jSONReader, JsonParser jsonParser, String string) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY.isEnabled(jSONReader._features)) {
            throw JSONObjectException.from(jsonParser, "Unrecognized JSON property '" + string + "' for Bean type " + this._type.getName());
        }
        jsonParser.nextToken();
        jsonParser.skipChildren();
    }

    protected IOException _reportProblem(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token " + (Object)((Object)jsonParser.getCurrentToken()) + "; should get FIELD_NAME or END_OBJECT");
    }
}

