/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DeferredMap
extends AbstractMap<Object, Object> {
    private Map<Object, Object> _map;
    private Object[] _entries;
    private int _end;
    private final boolean _ordered;

    public DeferredMap(boolean bl) {
        this(bl, 4);
    }

    public DeferredMap(boolean bl, int n) {
        this._ordered = bl;
    }

    @Override
    public Object put(Object object, Object object2) {
        if (this._map == null) {
            if (this._entries == null) {
                this._entries = new Object[8];
            } else if (this._end == this._entries.length) {
                int n = this._newSize(this._end);
                this._entries = Arrays.copyOf(this._entries, n);
            }
            this._entries[this._end] = object;
            this._entries[++this._end] = object2;
            ++this._end;
            return null;
        }
        return this._map.put(object, object2);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.buildIfNeeded();
        return this._map.entrySet();
    }

    @Override
    public int size() {
        return this._map == null ? this._end >> 1 : this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map == null ? this._end == 0 : this._map.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        this.buildIfNeeded();
        return this._map.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        this.buildIfNeeded();
        return this._map.containsKey(object);
    }

    @Override
    public Object get(Object object) {
        this.buildIfNeeded();
        return this._map.get(object);
    }

    @Override
    public Object remove(Object object) {
        this.buildIfNeeded();
        return this._map.remove(object);
    }

    @Override
    public void clear() {
        if (this._map != null) {
            this._map.clear();
        } else {
            this._end = 0;
        }
    }

    @Override
    public Set<Object> keySet() {
        this.buildIfNeeded();
        return this._map.keySet();
    }

    @Override
    public Collection<Object> values() {
        this.buildIfNeeded();
        return this._map.values();
    }

    @Override
    public boolean equals(Object object) {
        this.buildIfNeeded();
        return this._map.equals(object);
    }

    @Override
    public int hashCode() {
        this.buildIfNeeded();
        return this._map.hashCode();
    }

    @Override
    public String toString() {
        this.buildIfNeeded();
        return this._map.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        this.buildIfNeeded();
        if (this._map instanceof HashMap) {
            return ((HashMap)this._map).clone();
        }
        return new HashMap<Object, Object>(this._map);
    }

    protected void buildIfNeeded() {
        if (this._map == null) {
            this._map = this._buildMap(this._end >> 2);
            for (int i = 0; i < this._end; i += 2) {
                this._map.put((String)this._entries[i], this._entries[i + 1]);
            }
            this._entries = null;
        }
    }

    private final int _newSize(int n) {
        if (n < 200) {
            return n + n;
        }
        if (n < 2000) {
            return n + (n >> 1);
        }
        return n + (n >> 2);
    }

    protected Map<Object, Object> _buildMap(int n) {
        int n2 = n < 4 ? 4 : n + 3 * (n >> 3);
        if (this._ordered) {
            return new LinkedHashMap<Object, Object>(n2);
        }
        return new HashMap<Object, Object>(n2);
    }
}

