/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import com.fasterxml.jackson.jr.private.JsonParser;
import com.fasterxml.jackson.jr.private.JsonToken;
import java.io.IOException;
import java.util.Map;

public class EnumReader
extends ValueReader {
    protected final Object[] _byIndex;
    protected final Map<String, Object> _byName;

    public EnumReader(Object[] objectArray, Map<String, Object> map) {
        this._byIndex = objectArray;
        this._byName = map;
    }

    private String desc() {
        return this._byIndex[0].getClass().getName();
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            int n = jsonParser.getIntValue();
            if (n < 0 || n >= this._byIndex.length) {
                throw new JSONObjectException("Failed to bind Enum " + this.desc() + " with index " + n + " (has " + this._byIndex.length + " values)");
            }
            return this._byIndex[n];
        }
        String string = jsonParser.getValueAsString().trim();
        Object object = this._byName.get(string);
        if (object == null) {
            throw new JSONObjectException("Failed to find Enum of type " + this.desc() + " for value '" + string + "'");
        }
        return object;
    }
}

