/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.jaxrs.base.ProviderBase;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.xml.PackageVersion;
import com.fasterxml.jackson.jaxrs.xml.XMLEndpointConfig;
import com.fasterxml.jackson.jaxrs.xml.XMLMapperConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"text/xml", "application/xml"})
@Produces(value={"text/xml", "application/xml"})
public class JacksonXMLProvider
extends ProviderBase<JacksonXMLProvider, XmlMapper, XMLEndpointConfig, XMLMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonXMLProvider() {
        this((XmlMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonXMLProvider(Annotations ... annotationsArray) {
        this((XmlMapper)null, annotationsArray);
    }

    public JacksonXMLProvider(XmlMapper xmlMapper) {
        this(xmlMapper, BASIC_ANNOTATIONS);
    }

    public JacksonXMLProvider(XmlMapper xmlMapper, Annotations[] annotationsArray) {
        super((MapperConfiguratorBase)new XMLMapperConfigurator(xmlMapper, annotationsArray));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected XMLEndpointConfig _configForReading(ObjectReader objectReader, Annotation[] annotationArray) {
        return XMLEndpointConfig.forReading(objectReader, annotationArray);
    }

    protected XMLEndpointConfig _configForWriting(ObjectWriter objectWriter, Annotation[] annotationArray) {
        return XMLEndpointConfig.forWriting(objectWriter, annotationArray);
    }

    @Deprecated
    protected boolean isXMLType(MediaType mediaType) {
        return this.hasMatchingMediaType(mediaType);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String string = mediaType.getSubtype();
            return "xml".equalsIgnoreCase(string) || string.endsWith("+xml");
        }
        return true;
    }

    public XmlMapper _locateMapperViaProvider(Class<?> clazz, MediaType mediaType) {
        XmlMapper xmlMapper = ((XMLMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (xmlMapper == null) {
            if (this._providers != null) {
                ContextResolver contextResolver = this._providers.getContextResolver(XmlMapper.class, mediaType);
                if (contextResolver == null) {
                    contextResolver = this._providers.getContextResolver(XmlMapper.class, null);
                }
                if (contextResolver != null) {
                    xmlMapper = (XmlMapper)contextResolver.getContext(clazz);
                }
            }
            if (xmlMapper == null) {
                xmlMapper = ((XMLMapperConfigurator)this._mapperConfig).getDefaultMapper();
            }
        }
        return xmlMapper;
    }

    protected JsonParser _createParser(ObjectReader objectReader, InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        int n = pushbackInputStream.read();
        if (n == -1) {
            return null;
        }
        pushbackInputStream.unread(n);
        return objectReader.getFactory().createParser((InputStream)pushbackInputStream);
    }
}

