/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.UTF8Reader;
import com.fasterxml.jackson.dataformat.yaml.UTF8Writer;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.DumperOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;

public class YAMLFactory
extends JsonFactory {
    private static final long serialVersionUID = 1171663157274350349L;
    public static final String FORMAT_NAME_YAML = "YAML";
    protected static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLParser.Feature.collectDefaults();
    protected static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLGenerator.Feature.collectDefaults();
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    protected int _yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
    protected int _yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    protected DumperOptions.Version _version;
    protected final Charset UTF8 = Charset.forName("UTF-8");

    public YAMLFactory() {
        this(null);
    }

    public YAMLFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
        this._yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
        this._version = null;
    }

    public YAMLFactory(YAMLFactory yAMLFactory, ObjectCodec objectCodec) {
        super((JsonFactory)yAMLFactory, objectCodec);
        this._version = yAMLFactory._version;
        this._yamlParserFeatures = yAMLFactory._yamlParserFeatures;
        this._yamlGeneratorFeatures = yAMLFactory._yamlGeneratorFeatures;
    }

    public YAMLFactory copy() {
        this._checkInvalidCopy(YAMLFactory.class);
        return new YAMLFactory(this, null);
    }

    protected Object readResolve() {
        return new YAMLFactory(this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
        }
        if (by == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45) {
            return MatchStrength.FULL_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final YAMLFactory configure(YAMLParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLParser.Feature feature) {
        this._yamlParserFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLParser.Feature feature) {
        this._yamlParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLParser.Feature feature) {
        return (this._yamlParserFeatures & feature.getMask()) != 0;
    }

    public final YAMLFactory configure(YAMLGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLGenerator.Feature feature) {
        this._yamlGeneratorFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLGenerator.Feature feature) {
        this._yamlGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator.Feature feature) {
        return (this._yamlGeneratorFeatures & feature.getMask()) != 0;
    }

    public YAMLParser createParser(String string) throws IOException, JsonParseException {
        Reader reader = new StringReader(string);
        IOContext iOContext = this._createContext(reader, true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createParser(reader, iOContext);
    }

    public YAMLParser createParser(File file) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(file, true);
        InputStream inputStream = new FileInputStream(file);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createParser(inputStream, iOContext);
    }

    public YAMLParser createParser(URL uRL) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(uRL, true);
        InputStream inputStream = this._optimizedStreamFromURL(uRL);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createParser(inputStream, iOContext);
    }

    public YAMLParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(inputStream, false);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createParser(inputStream, iOContext);
    }

    public JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(reader, false);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createParser(reader, iOContext);
    }

    public YAMLParser createParser(byte[] byArray) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    public YAMLParser createParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n, n2)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n, n2, iOContext);
    }

    @Deprecated
    public YAMLParser createJsonParser(String string) throws IOException, JsonParseException {
        return this.createParser(string);
    }

    @Deprecated
    public YAMLParser createJsonParser(File file) throws IOException, JsonParseException {
        return this.createParser(file);
    }

    @Deprecated
    public YAMLParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this.createParser(uRL);
    }

    @Deprecated
    public YAMLParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this.createParser(inputStream);
    }

    @Deprecated
    public JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        return this.createParser(reader);
    }

    @Deprecated
    public YAMLParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        return this.createParser(byArray);
    }

    @Deprecated
    public YAMLParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this.createParser(byArray, n, n2);
    }

    public YAMLGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        if (this._outputDecorator != null) {
            outputStream = this._outputDecorator.decorate(iOContext, outputStream);
        }
        return this._createGenerator(this._createWriter(outputStream, JsonEncoding.UTF8, iOContext), iOContext);
    }

    public YAMLGenerator createGenerator(OutputStream outputStream) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        if (this._outputDecorator != null) {
            outputStream = this._outputDecorator.decorate(iOContext, outputStream);
        }
        return this._createGenerator(this._createWriter(outputStream, JsonEncoding.UTF8, iOContext), iOContext);
    }

    public YAMLGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createGenerator(writer, iOContext);
    }

    @Deprecated
    public YAMLGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public YAMLGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream);
    }

    @Deprecated
    public YAMLGenerator createJsonGenerator(Writer writer) throws IOException {
        return this.createGenerator(writer);
    }

    protected YAMLParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        Reader reader = this._createReader(inputStream, null, iOContext);
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    protected YAMLParser _createParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    protected YAMLParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        Reader reader = this._createReader(byArray, n, n2, null, iOContext);
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    @Deprecated
    protected YAMLParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(inputStream, iOContext);
    }

    @Deprecated
    protected JsonParser _createJsonParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(reader, iOContext);
    }

    @Deprecated
    protected YAMLParser _createJsonParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, iOContext);
    }

    protected YAMLGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        int n = this._yamlGeneratorFeatures;
        YAMLGenerator yAMLGenerator = new YAMLGenerator(iOContext, this._generatorFeatures, n, this._objectCodec, writer, this._version);
        return yAMLGenerator;
    }

    @Deprecated
    protected YAMLGenerator _createJsonGenerator(Writer writer, IOContext iOContext) throws IOException {
        return this._createGenerator(writer, iOContext);
    }

    @Deprecated
    protected YAMLGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createGenerator(new UTF8Writer(outputStream), iOContext);
    }

    @Deprecated
    protected YAMLGenerator _createUTF8JsonGenerator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createUTF8Generator(outputStream, iOContext);
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(InputStream inputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == JsonEncoding.UTF8) {
            boolean bl = iOContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(inputStream, bl);
        }
        return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(byte[] byArray, int n, int n2, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == null || jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Reader(byArray, n, n2, true);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        return new InputStreamReader((InputStream)byteArrayInputStream, jsonEncoding.getJavaName());
    }
}

