/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = -4138605166320336475L;
    protected static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup rootNames) {
        this._rootNameLookup = rootNames;
    }

    public XmlSerializerProvider(XmlSerializerProvider src, SerializationConfig config, SerializerFactory f) {
        super((SerializerProvider)src, config, f);
        this._rootNameLookup = src._rootNameLookup;
    }

    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new XmlSerializerProvider(this, config, jsf);
    }

    public void serializeValue(JsonGenerator jgen, Object value) throws IOException {
        boolean asArray;
        if (value == null) {
            this._serializeXmlNull(jgen);
            return;
        }
        Class<?> cls = value.getClass();
        ToXmlGenerator xgen = this._asXmlGenerator(jgen);
        if (xgen == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(cls, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(cls);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        JsonSerializer ser = this.findTypedValueSerializer(cls, true, null);
        try {
            ser.serialize(value, jgen, (SerializerProvider)this);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "[no message for " + e.getClass().getName() + "]";
            }
            throw new JsonMappingException(msg, (Throwable)e);
        }
        if (asArray) {
            jgen.writeEndObject();
        }
    }

    public void serializeValue(JsonGenerator jgen, Object value, JavaType rootType) throws IOException {
        boolean asArray;
        if (value == null) {
            this._serializeXmlNull(jgen);
            return;
        }
        ToXmlGenerator xgen = this._asXmlGenerator(jgen);
        if (xgen == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        JsonSerializer ser = this.findTypedValueSerializer(rootType, true, null);
        try {
            ser.serialize(value, jgen, (SerializerProvider)this);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "[no message for " + e.getClass().getName() + "]";
            }
            throw new JsonMappingException(msg, (Throwable)e);
        }
        if (asArray) {
            jgen.writeEndObject();
        }
    }

    public void serializeValue(JsonGenerator jgen, Object value, JavaType rootType, JsonSerializer<Object> ser) throws IOException {
        boolean asArray;
        if (value == null) {
            this._serializeXmlNull(jgen);
            return;
        }
        ToXmlGenerator xgen = this._asXmlGenerator(jgen);
        if (xgen == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        if (ser == null) {
            ser = this.findTypedValueSerializer(rootType, true, null);
        }
        try {
            ser.serialize(value, jgen, (SerializerProvider)this);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "[no message for " + e.getClass().getName() + "]";
            }
            throw new JsonMappingException(msg, (Throwable)e);
        }
        if (asArray) {
            jgen.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator jgen) throws IOException {
        if (jgen instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)jgen, ROOT_NAME_FOR_NULL);
        }
        super.serializeValue(jgen, null);
    }

    protected void _startRootArray(ToXmlGenerator xgen, QName rootName) throws IOException {
        xgen.writeStartObject();
        xgen.writeFieldName("item");
    }

    protected void _initWithRootName(ToXmlGenerator xgen, QName rootName) throws IOException {
        if (!xgen.setNextNameIfMissing(rootName) && xgen.getOutputContext().inRoot()) {
            xgen.setNextName(rootName);
        }
        xgen.initGenerator();
        String ns = rootName.getNamespaceURI();
        if (ns != null && ns.length() > 0) {
            try {
                xgen.getStaxWriter().setDefaultNamespace(ns);
            }
            catch (XMLStreamException e) {
                StaxUtil.throwXmlAsIOException(e);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        String name = this._config.getRootName();
        return name == null ? null : new QName(name);
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator jgen) throws JsonMappingException {
        if (!(jgen instanceof ToXmlGenerator)) {
            if (!(jgen instanceof TokenBuffer)) {
                throw new JsonMappingException("XmlMapper does not with generators of type other than ToXmlGenerator; got: " + jgen.getClass().getName());
            }
            return null;
        }
        return (ToXmlGenerator)jgen;
    }
}

