/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.PackageVersion;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.ser.XmlSerializerProvider;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;

public class XmlMapper
extends ObjectMapper {
    private static final long serialVersionUID = -724333029147285918L;
    protected static final JacksonXmlModule DEFAULT_XML_MODULE = new JacksonXmlModule();
    protected final JacksonXmlModule _xmlModule;

    public XmlMapper() {
        this(new XmlFactory());
    }

    public XmlMapper(XmlFactory xmlFactory) {
        this(xmlFactory, DEFAULT_XML_MODULE);
    }

    public XmlMapper(JacksonXmlModule module) {
        this(new XmlFactory(), module);
    }

    public XmlMapper(XmlFactory xmlFactory, JacksonXmlModule module) {
        super((JsonFactory)xmlFactory, (DefaultSerializerProvider)new XmlSerializerProvider(new XmlRootNameLookup()), null);
        this._xmlModule = module;
        if (module != null) {
            this.registerModule((Module)module);
        }
    }

    public XmlMapper copy() {
        this._checkInvalidCopy(XmlMapper.class);
        return new XmlMapper((XmlFactory)this._jsonFactory.copy(), this._xmlModule);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected void setXMLTextElementName(String name) {
        ((XmlFactory)this._jsonFactory).setXMLTextElementName(name);
    }

    @Deprecated
    public XmlFactory getJsonFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public XmlFactory getFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public ObjectMapper configure(ToXmlGenerator.Feature f, boolean state) {
        ((XmlFactory)this._jsonFactory).configure(f, state);
        return this;
    }

    public ObjectMapper configure(FromXmlParser.Feature f, boolean state) {
        ((XmlFactory)this._jsonFactory).configure(f, state);
        return this;
    }

    public ObjectMapper enable(ToXmlGenerator.Feature f) {
        ((XmlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ObjectMapper enable(FromXmlParser.Feature f) {
        ((XmlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ObjectMapper disable(ToXmlGenerator.Feature f) {
        ((XmlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public ObjectMapper disable(FromXmlParser.Feature f) {
        ((XmlFactory)this._jsonFactory).disable(f);
        return this;
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return new DefaultXmlPrettyPrinter();
    }
}

